####################################################################################
# Copyright (c) 2008 Chris Armstrong (chrisarm aatt gmail ddott com)
####################################################################################
# Notes:
#   -The count method doesn't seem to be working... maybe I'm doing it wrong but 
#   I got the sum method working so I'm pretty sure I was doing it right.
#   >>> summed = Grouping.summarize_by_value(BidsTestData, "bidderID", sum="sum(group['bidID'])")
#   >>> counted = Grouping.summarize_by_value(BidsTestData, "bidderID", counted="count(group['bidID'])")
####################################################################################

DETECTLET_STANDARD = 1.0

from picalo import *

wizard = '''
<wizard>
  <page>
    Select the TABLE with information on bids/estimates. 
    
    It should contain the following
    information relating to each bid: the bid ID#, the bidder/vendor ID#, contract 
    ID#, bid amount, a column indicating if the bid was the winning bid, and a 
    column indicating if the bid was withdrawn.
    <parameter type="Table" variable="bidTable"/>
  </page>
  <page>
    Select the COLUMN containing the bids/estimates identification number:
    
    This is usually
    called something like BidID, bid_number, or estimate_id. 
    <parameter type="Column" table="bidTable" variable="bidID" multiple="false"/>
    
    Select the COLUMN containing the bidder/vendor identification number:
    
    This is usually called something like BidderID, bider_num, or vendor_id. 
    <parameter type="Column" table="bidTable" variable="bidderID" multiple="false"/>
  </page>
  <page>
    Select the COLUMN that contains the contract ID:
    
    It is usually called
    something like contract_number or ContractID.
    <parameter type="Column" table="bidTable" variable="contractID" multiple="false"/>
    
    Select the column that contains the bid/estimate amount. It is usually called
    something like total or amount.
    <parameter type="Column" table="bidTable" variable="bidAmount" multiple="false"/>
  </page>
  <page>
    Select the COLUMN indicating whether or not the bid/estimate was retracted or 
    not. This field is usually called something like status, withdrawn, or 
    cancelled and it will contain data that indicates if a bid was withdrawn or 
    if it is still valid. 
    <parameter type="Column" table="bidTable" variable="withdrawnColumn" multiple="false"/>

    Enter how a withdrawn bid is marked. This tells the detectlet how to determine
    if a bid has been retracted. Meaning, is the Status column set to 'withdrawn' or 
    'cancelled', or is the Withdrawn column marked 'true'?
    
    For example if the column selected above is called 'Withdrawn' and a value of 
    'true' indicates that the bid has been withdrawn, you would enter 'true' in 
    the box below. If the the column is called 'Status' and a value of 'Cancelled' 
    indicates that the bid was cancelled then you would enter 'Cancelled' below.
    This is not case sensitive, so 'True' = 'true' = 'TRUE' etc.
    <parameter type="string" variable="withdrawnIndicator" default = "Withdrawn"/>
  </page>
  <page>
    Select the COLUMN indicating whether or not the bid/estimate was the winning bid.
    This field is usually called something like status, winning_bid, or winner 
    and it will contain data that indicates if a bid won or not. 
    <parameter type="Column" table="bidTable" variable="winnerColumn" multiple="false"/>

    Enter how a winning bid is marked. This tells the detectlet how to determine
    if a bid was the winning bid. Meaning, is the column you selected set to 'won' 
    or 'winning', or is the winning bid column marked 'true'?
    
    For example if the column selected above is called 'Winning_Bid' and a value 
    of 'true' indicates that the bid won the contract, you would enter 'true' in 
    the box below. If the the column is called 'Status' and a value of 'Won' 
    indicates that the bid won then you would enter 'Won' below. This is not case 
    sensitive, so 'Won' = 'won' = 'WON' etc.
    <parameter type="string" variable="winnerIndicator" default="Won"/>
  </page>
  
</wizard>
'''

RESULTS_TEXT = '''\
    The results table lists bids that were retracted even though they were the lowest
    bid and would have otherwise won the contract. These bids should be 
    investigated to see if certain bidders/vendors are regularly retracting their 
    low bids so that other bidders can win the contract. It is especially 
    suspicious if the same bidders are seen doing this over and over.
'''

def append_columnStruct(appendTable, structureRow):
    index = structureRow[1].find(' ')
    columnName = structureRow[0]
    columnType = structureRow[1][index+2:-2]
    
    if columnType == 'int':
        appendTable.append_column(columnName, int)
    if columnType == 'long':
        appendTable.append_column(columnName, long)
    if columnType == 'float':
        appendTable.append_column(columnName, float)
    elif columnType == 'unicode':
        appendTable.append_column(columnName, unicode)
    elif columnType == 'picalo.base.Currency.currency':
        appendTable.append_column(columnName, currency)
    elif columnType == 'picalo.base.Calendar.Date':
        appendTable.append_column(columnName, Date)
    elif columnType == 'picalo.base.Calendar.DateTime':
        appendTable.append_column(columnName, DateTime)
    return appendTable


def run(bidTable, bidID, bidderID, contractID, bidAmount, withdrawnColumn, withdrawnIndicator, winnerColumn, winnerIndicator):
    '''When the bids for amounts lower than the winner are withdrawn, it may be an 
    indication of fraud. This type of fraud happens when conspirators retract their 
    bid since it is lower so that a chosen winner with a higher bid amount will get 
    the contract. It is a type of bid suppression.   
    '''
    # copy the structure of the original table for results
    resultsStucture = bidTable.structure()
    results = Table(columns=1, data=[])
    for row in resultsStucture:
        results = append_columnStruct(results,row)
    results.delete_column('col000')
    columnNames = results.get_column_names()
    
    # copy the structure of the original table as a temporary storage for data
    tempStucture = bidTable.structure()
    temp = Table(columns=1, data=[])
    for row in tempStucture:
        temp = append_columnStruct(temp,row)
    temp.delete_column('col000')
    columnNames = temp.get_column_names()
    
    #Separate bids by contract
    ContractBids = Grouping.stratify_by_value(bidTable, contractID)
    
    #Find winning bids
    for bidTable in ContractBids:
        for bid in bidTable:
            if bid[winnerColumn].lower() == winnerIndicator.lower(): 
                temp.append(bid)
    
    #Find bids lower than the winning bids that were withdrawn
    for bidTable in ContractBids:
        winBidAmount = 0
        for bid in bidTable:
            for winbid in temp:
                if bid[contractID] == winbid[contractID]:
                    winBidAmount = winbid[bidAmount]
            if winBidAmount == None or winBidAmount == '':
                winBidAmount = 0
            if bid[withdrawnColumn].lower() == withdrawnIndicator.lower() and bid[bidAmount] < winBidAmount:
                results.append(bid)

    #TODO When method is working then I'll have code to return a table with
    #   a list of vendors who have multiple bids retracted below the winning bid, how
    #   many times they've done it, and what contracts were involvd.
 
    return results, RESULTS_TEXT

def example_input():
    import StringIO  # to emulate a file for load_csv
    table_BidsTestData = load_csv(StringIO.StringIO(csvdata_BidsTestData))
    return table_BidsTestData

csvdata_BidsTestData = '''\
bidID,bidderID,contractID,bidAmount,bidStatus
1,2052,123,$22050.00,won
2,1902,123,$22275.00,lost
3,1938,123,$22500.00,lost
4,1989,123,$22950.00,lost
5,2046,123,$23400.00,lost
6,2052,124,$10000.12,won
7,1902,124,$10102.16,withdrawn
8,1938,124,$10204.20,lost
9,1989,124,$10408.28,withdrawn
10,2046,124,$10612.37,lost
11,2052,125,$12005.00,won
12,1902,125,$12127.50,lost
13,1938,125,$12250.00,lost
14,1989,125,$12495.00,lost
15,2046,125,$12740.00,lost
16,2052,126,$10302.35,won
17,1902,126,$10407.47,withdrawn
18,1938,126,$10512.60,lost
19,1989,126,$10722.85,withdrawn
20,2046,126,$10933.10,lost
21,1902,127,$24916.50,withdrawn
22,2052,127,$25170.75,won
23,1938,127,$25425.00,lost
24,1989,127,$25933.50,lost
25,2046,127,$26442.00,lost
26,2052,128,$11300.13,won
27,1902,128,$11415.44,withdrawn
28,1938,128,$11530.75,lost
29,1989,128,$11761.36,withdrawn
30,2046,128,$11991.98,lost
31,2052,129,$13565.65,won
32,1902,129,$13704.08,withdrawn
33,1938,129,$13842.50,lost
34,1989,129,$14119.35,lost
35,2046,129,$14396.20,lost
36,2052,130,$11641.65,won
37,1902,130,$11760.45,withdrawn
38,1938,130,$11879.24,lost
39,1989,130,$12116.82,withdrawn
40,2046,130,$12354.41,lost
41,2052,131,$24916.50,won
42,1902,131,$25170.75,withdrawn
43,1938,131,$25425.00,lost
44,1989,131,$25933.50,lost
45,2046,131,$26442.00,lost
46,2052,132,$11300.13,won
47,1902,132,$11415.44,withdrawn
48,1938,132,$11530.75,lost
49,1989,132,$11761.36,withdrawn
50,2046,132,$11991.98,lost
51,2052,133,$13565.65,won
52,1902,133,$13704.08,lost
53,1938,133,$13842.50,withdrawn
54,1989,133,$14119.35,lost
55,2046,133,$14396.20,lost
56,2052,134,$11641.65,won
57,1902,134,$11760.45,withdrawn
58,1938,134,$11879.24,lost
59,1989,134,$12116.82,withdrawn
60,2046,134,$12354.41,lost
61,1902,135,$28155.65,withdrawn
62,2052,135,$28442.95,won
63,1938,135,$28730.25,lost
64,1989,135,$29304.86,lost
65,2046,135,$29879.46,lost
66,2052,136,$12769.15,won
67,1902,136,$12899.45,withdrawn
68,1938,136,$13029.74,lost
69,1989,136,$13290.34,withdrawn
70,2046,136,$13550.93,lost
71,2052,137,$15329.18,won
72,1902,137,$15485.60,withdrawn
73,1938,137,$15642.03,lost
74,1989,137,$15954.87,lost
75,2046,137,$16267.71,lost
76,2052,138,$13155.07,won
77,1902,138,$13289.30,withdrawn
78,1938,138,$13423.54,lost
79,1989,138,$13692.01,withdrawn
80,2046,138,$13960.48,lost
81,2052,139,$19315.80,won
82,1902,139,$19512.90,withdrawn
83,1938,139,$19710.00,lost
84,1989,139,$20104.20,lost
85,2046,139,$20498.40,withdrawn
86,2052,140,$8760.10,won
87,1902,140,$8849.49,withdrawn
88,1938,140,$8938.88,lost
89,1989,140,$9117.66,withdrawn
90,2046,140,$9296.43,lost
91,2052,141,$10516.38,won
92,1902,141,$10623.69,lost
93,1938,141,$10731.00,lost
94,1989,141,$10945.62,lost
95,2046,141,$11160.24,lost
96,2052,142,$9024.86,won
97,1902,142,$9116.95,withdrawn
98,1938,142,$9209.04,lost
99,1989,142,$9393.22,withdrawn
100,2046,142,$9577.40,lost
101,1902,143,$21826.85,withdrawn
102,2052,143,$22049.58,won
103,1938,143,$22272.30,lost
104,1989,143,$22717.75,lost
105,2046,143,$23163.19,lost
106,2052,144,$9898.91,won
107,1902,144,$9999.92,withdrawn
108,1938,144,$10100.93,lost
109,1989,144,$10302.95,withdrawn
110,2046,144,$10504.97,lost
111,2052,145,$11883.51,won
112,1902,145,$12004.77,withdrawn
113,1938,145,$12126.03,lost
114,1989,145,$12368.55,lost
115,2046,145,$12611.07,lost
116,2052,146,$10198.09,won
117,1902,146,$10302.15,withdrawn
118,1938,146,$10406.21,lost
119,1989,146,$10614.34,withdrawn
120,2046,146,$10822.46,lost
121,2052,147,$21826.85,won
122,1902,147,$22049.58,withdrawn
123,1938,147,$22272.30,lost
124,1989,147,$22717.75,lost
125,2046,147,$23163.19,withdrawn
126,2052,148,$9898.91,won
127,1902,148,$9999.92,withdrawn
128,1938,148,$10100.93,lost
129,1989,148,$10302.95,withdrawn
130,2046,148,$10504.97,lost
131,2046,149,$11883.51,withdrawn
132,1902,149,$12004.77,won
133,1938,149,$12126.03,lost
134,1989,149,$12368.55,lost
135,2052,149,$12611.07,lost
136,2052,150,$10198.09,won
137,1902,150,$10302.15,withdrawn
138,1938,150,$10406.21,lost
139,1989,150,$10614.34,withdrawn
140,2046,150,$10822.46,lost
141,1902,151,$24664.35,withdrawn
142,2052,151,$24916.02,won
143,1938,151,$25167.70,lost
144,1989,151,$25671.05,lost
145,2046,151,$26174.41,lost
146,2052,152,$11185.77,won
147,1902,152,$11299.91,withdrawn
148,1938,152,$11414.05,lost
149,1989,152,$11642.34,withdrawn
150,2046,152,$11870.62,lost
151,2052,153,$13428.37,won
152,1902,153,$13565.39,withdrawn
153,1938,153,$13702.41,lost
154,1989,153,$13976.46,lost
155,2046,153,$14250.51,lost
156,2052,154,$11523.84,won
157,1902,154,$11641.43,withdrawn
158,1938,154,$11759.02,lost
159,1989,154,$11994.20,withdrawn
160,2046,154,$12229.38,lost
161,2046,155,$19315.80,won
162,2052,155,$19512.90,lost
163,1938,155,$19710.00,lost
164,1989,155,$20104.20,lost
165,1902,155,$20498.40,lost
166,2052,156,$8760.10,won
167,1902,156,$8849.49,withdrawn
168,1938,156,$8938.88,lost
169,1989,156,$9117.66,withdrawn
170,2046,156,$9296.43,lost
171,2052,157,$10516.38,won
172,1902,157,$10623.69,lost
173,1938,157,$10731.00,lost
174,1989,157,$10945.62,lost
175,2046,157,$11160.24,lost
176,2052,158,$9024.86,won
177,1902,158,$9116.95,withdrawn
178,1938,158,$9209.04,lost
179,1989,158,$9393.22,withdrawn
180,2046,158,$9577.40,lost
181,1902,159,$21826.85,withdrawn
182,2052,159,$22049.58,won
183,1938,159,$22272.30,lost
184,1989,159,$22717.75,lost
185,2046,159,$23163.19,lost
186,2052,160,$9898.91,won
187,1902,160,$9999.92,withdrawn
188,1938,160,$10100.93,lost
189,1989,160,$10302.95,withdrawn
190,2046,160,$10504.97,lost
191,2052,161,$11883.51,won
192,1902,161,$12004.77,withdrawn
193,1938,161,$12126.03,lost
194,1989,161,$12368.55,lost
195,2046,161,$12611.07,lost
196,2052,162,$10198.09,won
197,1902,162,$10302.15,withdrawn
198,1938,162,$10406.21,lost
199,1989,162,$10614.34,withdrawn
200,2046,162,$10822.46,lost
201,2052,163,$21826.85,won
202,1902,163,$22049.58,lost
203,1938,163,$22272.30,lost
204,1989,163,$22717.75,lost
205,2046,163,$23163.19,lost
206,2052,164,$9898.91,won
207,1902,164,$9999.92,withdrawn
208,1938,164,$10100.93,lost
209,1989,164,$10302.95,withdrawn
210,2046,164,$10504.97,lost
211,2052,165,$11883.51,won
212,1902,165,$12004.77,lost
213,1938,165,$12126.03,lost
214,1989,165,$12368.55,lost
215,2046,165,$12611.07,lost
216,2052,166,$10198.09,won
217,1902,166,$10302.15,withdrawn
218,1938,166,$10406.21,lost
219,1989,166,$10614.34,withdrawn
220,2046,166,$10822.46,lost
221,1902,167,$24664.35,withdrawn
222,2052,167,$24916.02,won
223,1938,167,$25167.70,lost
224,1989,167,$25671.05,lost
225,2046,167,$26174.41,lost
226,2052,168,$11185.77,won
227,1902,168,$11299.91,withdrawn
228,1938,168,$11414.05,lost
229,1989,168,$11642.34,withdrawn
230,2046,168,$11870.62,lost
231,2052,169,$13428.37,won
232,1902,169,$13565.39,withdrawn
233,1938,169,$13702.41,lost
234,1989,169,$13976.46,lost
235,2046,169,$14250.51,lost
236,2052,170,$11523.84,won
237,1902,170,$11641.43,withdrawn
238,1938,170,$11759.02,lost
239,1989,170,$11994.20,withdrawn
240,2046,170,$12229.38,lost
241,2052,171,$16920.64,won
242,1902,171,$17093.30,lost
243,1938,171,$17265.96,lost
244,1989,171,$17611.28,lost
245,2046,171,$17956.60,lost
246,2052,172,$7673.85,won
247,1902,172,$7752.15,withdrawn
248,1938,172,$7830.46,lost
249,1989,172,$7987.07,withdrawn
250,2046,172,$8143.68,lost
251,2052,173,$9212.35,withdrawn
252,1902,173,$9306.35,won
253,1938,173,$9400.36,lost
254,1989,173,$9588.36,lost
255,2046,173,$9776.37,lost
256,2052,174,$7905.77,won
257,1902,174,$7986.45,withdrawn
258,1938,174,$8067.12,lost
259,1989,174,$8228.46,withdrawn
260,2046,174,$8389.80,lost
261,1902,175,$19120.32,withdrawn
262,2052,175,$19315.43,won
263,1938,175,$19510.53,lost
264,1989,175,$19900.75,lost
265,2046,175,$20290.96,lost
266,2052,176,$8671.45,won
267,1902,176,$8759.93,withdrawn
268,1938,176,$8848.42,lost
269,1989,176,$9025.39,withdrawn
270,2046,176,$9202.35,lost
271,2052,177,$10409.95,won
272,1902,177,$10516.18,withdrawn
273,1938,177,$10622.40,lost
274,1989,177,$10834.85,lost
275,2046,177,$11047.30,lost
276,2052,178,$8933.53,won
277,1902,178,$9024.68,withdrawn
278,1938,178,$9115.84,lost
279,1989,178,$9298.16,withdrawn
280,2046,178,$9480.48,lost
281,2052,179,$19120.32,won
282,1902,179,$19315.43,lost
283,1938,179,$19510.53,lost
284,1989,179,$19900.75,lost
285,2046,179,$20290.96,lost
286,2052,180,$8671.45,won
287,1902,180,$8759.93,withdrawn
288,1938,180,$8848.42,lost
289,1989,180,$9025.39,withdrawn
290,2046,180,$9202.35,lost
291,2052,181,$10409.95,won
292,1902,181,$10516.18,lost
293,1938,181,$10622.40,lost
294,1989,181,$10834.85,lost
295,2046,181,$11047.30,lost
296,2052,182,$8933.53,won
297,1902,182,$9024.68,withdrawn
298,1938,182,$9115.84,lost
299,1989,182,$9298.16,withdrawn
300,2046,182,$9480.48,lost
301,1902,183,$21605.97,withdrawn
302,2052,183,$21826.44,won
303,1938,183,$22046.90,lost
304,1989,183,$22487.84,lost
305,2046,183,$22928.78,lost
306,2052,184,$9798.74,won
307,1902,184,$9898.72,withdrawn
308,1938,184,$9998.71,lost
309,1989,184,$10198.69,withdrawn
310,2046,184,$10398.66,lost
311,2052,185,$11763.25,won
312,1902,185,$11883.28,withdrawn
313,1938,185,$12003.31,lost
314,1989,185,$12243.38,lost
315,2046,185,$12483.45,lost
316,2052,186,$10094.88,won
317,1902,186,$10197.89,withdrawn
318,1938,186,$10300.90,lost
319,1989,186,$10506.92,withdrawn
320,2046,186,$10712.94,lost
321,2052,187,$36999.90,withdrawn
322,1902,187,$37377.45,withdrawn
323,1938,187,$37755.00,withdrawn
324,1989,187,$38510.10,withdrawn
325,2046,187,$39265.20,won
326,2052,188,$16780.19,won
327,1902,188,$16951.42,withdrawn
328,1938,188,$17122.65,lost
329,1989,188,$17465.10,withdrawn
330,2046,188,$17807.55,lost
331,2052,189,$20144.39,won
332,1902,189,$20349.95,lost
333,1938,189,$20555.50,lost
334,1989,189,$20966.61,lost
335,2046,189,$21377.72,lost
336,2052,190,$17287.34,won
337,1902,190,$17463.74,withdrawn
338,1938,190,$17640.14,lost
339,1989,190,$17992.95,withdrawn
340,2046,190,$18345.75,lost
341,1902,191,$41809.89,withdrawn
342,2052,191,$42236.52,won
343,1938,191,$42663.15,lost
344,1989,191,$43516.41,lost
345,2046,191,$44369.68,lost
346,2052,192,$18961.62,won
347,1902,192,$19155.11,withdrawn
348,1938,192,$19348.59,lost
349,1989,192,$19735.56,withdrawn
350,2046,192,$20122.54,lost
351,2052,193,$22763.16,won
352,1902,193,$22995.44,withdrawn
353,1938,193,$23227.72,lost
354,1989,193,$23692.27,lost
355,2046,193,$24156.82,lost
356,2052,194,$19534.69,won
357,1902,194,$19734.03,withdrawn
358,1938,194,$19933.36,lost
359,1989,194,$20332.03,withdrawn
360,2046,194,$20730.70,lost
361,2052,195,$41809.89,won
362,1902,195,$42236.52,lost
363,1938,195,$42663.15,lost
364,1989,195,$43516.41,lost
365,2046,195,$44369.68,lost
366,2052,196,$18961.62,won
367,1902,196,$19155.11,withdrawn
368,1938,196,$19348.59,lost
369,1989,196,$19735.56,withdrawn
370,2046,196,$20122.54,lost
371,2052,197,$22763.16,won
372,1902,197,$22995.44,lost
373,1938,197,$23227.72,lost
374,1989,197,$23692.27,lost
375,2046,197,$24156.82,lost
376,2052,198,$19534.69,won
377,1902,198,$19734.03,withdrawn
378,1938,198,$19933.36,lost
379,1989,198,$20332.03,withdrawn
380,2046,198,$20730.70,lost
381,1902,199,$47245.17,withdrawn
382,2052,199,$47727.27,won
383,1938,199,$48209.36,lost
384,1989,199,$49173.55,lost
385,2046,199,$50137.73,lost
386,2052,200,$21426.63,won
387,1902,200,$21645.27,withdrawn
388,1938,200,$21863.91,lost
389,1989,200,$22301.19,withdrawn
390,2046,200,$22738.47,lost
391,2052,201,$25722.37,won
392,1902,201,$25984.84,withdrawn
393,1938,201,$26247.32,lost
394,1989,201,$26772.26,lost
395,2046,201,$27297.21,lost
396,2052,202,$22074.20,won
397,1902,202,$22299.45,withdrawn
398,1938,202,$22524.70,lost
399,1989,202,$22975.19,withdrawn
400,2046,202,$23425.69,lost
401,2052,203,$32411.91,won
402,1902,203,$32742.65,lost
403,1938,203,$33073.38,lost
404,1989,203,$33734.85,lost
405,2046,203,$34396.32,lost
406,2052,204,$14699.45,won
407,1902,204,$14849.44,withdrawn
408,1938,204,$14999.44,lost
409,1989,204,$15299.43,withdrawn
410,2046,204,$15599.42,lost
411,2052,205,$17646.49,withdrawn
412,1902,205,$17826.55,won
413,1938,205,$18006.62,lost
414,1989,205,$18366.75,lost
415,2046,205,$18726.88,lost
416,2052,206,$15143.71,won
417,1902,206,$15298.24,withdrawn
418,1938,206,$15452.77,lost
419,1989,206,$15761.82,withdrawn
420,2046,206,$16070.88,lost
421,1902,207,$36625.46,withdrawn
422,2052,207,$36999.19,won
423,1938,207,$37372.92,lost
424,1989,207,$38120.38,lost
425,2046,207,$38867.84,lost
426,2052,208,$16610.38,won
427,1902,208,$16779.87,withdrawn
428,1938,208,$16949.37,lost
429,1989,208,$17288.35,withdrawn
430,2046,208,$17627.34,lost
431,2052,209,$19940.53,won
432,1902,209,$20144.00,withdrawn
433,1938,209,$20347.48,lost
434,1989,209,$20754.43,lost
435,2046,209,$21161.38,lost
436,2052,210,$17112.39,won
437,1902,210,$17287.01,withdrawn
438,1938,210,$17461.62,lost
439,1989,210,$17810.86,withdrawn
440,2046,210,$18160.09,lost
441,2052,211,$36625.46,withdrawn
442,1902,211,$36999.19,won
443,1938,211,$37372.92,lost
444,1989,211,$38120.38,lost
445,2046,211,$38867.84,lost
446,2052,212,$16610.38,won
447,1902,212,$16779.87,withdrawn
448,1938,212,$16949.37,lost
449,1989,212,$17288.35,withdrawn
450,2046,212,$17627.34,lost
451,2052,213,$19940.53,withdrawn
452,1902,213,$20144.00,won
453,1938,213,$20347.48,lost
454,1989,213,$20754.43,lost
455,2046,213,$21161.38,lost
456,2052,214,$17112.39,won
457,1902,214,$17287.01,withdrawn
458,1938,214,$17461.62,lost
459,1989,214,$17810.86,withdrawn
460,2046,214,$18160.09,lost
461,1902,215,$41386.77,withdrawn
462,2052,215,$41809.08,won
463,1938,215,$42231.40,lost
464,1989,215,$43076.03,lost
465,2046,215,$43920.65,lost
466,2052,216,$18769.73,won
467,1902,216,$18961.26,withdrawn
468,1938,216,$19152.78,lost
469,1989,216,$19535.84,withdrawn
470,2046,216,$19918.90,lost
471,2052,217,$22532.80,won
472,1902,217,$22762.72,withdrawn
473,1938,217,$22992.65,lost
474,1989,217,$23452.50,lost
475,2046,217,$23912.36,lost
476,2052,218,$19337.00,won
477,1902,218,$19534.32,withdrawn
478,1938,218,$19731.64,lost
479,1989,218,$20126.27,withdrawn
480,2046,218,$20520.90,lost
481,2052,219,$32411.91,withdrawn
482,1902,219,$32742.65,won
483,1938,219,$33073.38,lost
484,1989,219,$33734.85,lost
485,2046,219,$34396.32,lost
486,2052,220,$14699.45,won
487,1902,220,$14849.44,withdrawn
488,1938,220,$14999.44,lost
489,1989,220,$15299.43,withdrawn
490,2046,220,$15599.42,lost
491,2052,221,$17646.49,withdrawn
492,1902,221,$17826.55,won
493,1938,221,$18006.62,lost
494,1989,221,$18366.75,lost
495,2046,221,$18726.88,lost
496,2052,222,$15143.71,won
497,1902,222,$15298.24,withdrawn
498,1938,222,$15452.77,lost
499,1989,222,$15761.82,withdrawn
500,2046,222,$16070.88,lost
501,1902,223,$36625.46,withdrawn
502,2052,223,$36999.19,won
503,1938,223,$37372.92,lost
504,1989,223,$38120.38,lost
505,2046,223,$38867.84,lost
506,2052,224,$16610.38,won
507,1902,224,$16779.87,withdrawn
508,1938,224,$16949.37,lost
509,1989,224,$17288.35,withdrawn
510,2046,224,$17627.34,lost
511,2052,225,$19940.53,won
512,1902,225,$20144.00,withdrawn
513,1938,225,$20347.48,lost
514,1989,225,$20754.43,lost
515,2046,225,$21161.38,lost
516,2052,226,$17112.39,won
517,1902,226,$17287.01,withdrawn
518,1938,226,$17461.62,lost
519,1989,226,$17810.86,withdrawn
520,2046,226,$18160.09,lost
521,2052,227,$36625.46,withdrawn
522,1902,227,$36999.19,won
523,1938,227,$37372.92,lost
524,1989,227,$38120.38,lost
525,2046,227,$38867.84,lost
526,2052,228,$16610.38,won
527,1902,228,$16779.87,withdrawn
528,1938,228,$16949.37,lost
529,1989,228,$17288.35,withdrawn
530,2046,228,$17627.34,lost
531,2052,229,$19940.53,withdrawn
532,1902,229,$20144.00,won
533,1938,229,$20347.48,lost
534,1989,229,$20754.43,lost
535,2046,229,$21161.38,lost
536,2052,230,$17112.39,won
537,1902,230,$17287.01,withdrawn
538,1938,230,$17461.62,lost
539,1989,230,$17810.86,withdrawn
540,2046,230,$18160.09,lost
541,1902,231,$41386.77,withdrawn
542,2052,231,$41809.08,won
543,1938,231,$42231.40,lost
544,1989,231,$43076.03,lost
545,2046,231,$43920.65,lost
546,2052,232,$18769.73,won
547,1902,232,$18961.26,withdrawn
548,1938,232,$19152.78,lost
549,1989,232,$19535.84,withdrawn
550,2046,232,$19918.90,lost
551,2052,233,$22532.80,won
552,1902,233,$22762.72,withdrawn
553,1938,233,$22992.65,lost
554,1989,233,$23452.50,lost
555,2046,233,$23912.36,lost
556,2052,234,$19337.00,won
557,1902,234,$19534.32,withdrawn
558,1938,234,$19731.64,lost
559,1989,234,$20126.27,withdrawn
560,2046,234,$20520.90,lost
561,2052,235,$28392.84,withdrawn
562,1902,235,$28682.56,won
563,1938,235,$28972.28,lost
564,1989,235,$29551.73,lost
565,2046,235,$30131.17,lost
566,2052,236,$12876.72,won
567,1902,236,$13008.11,withdrawn
568,1938,236,$13139.51,lost
569,1989,236,$13402.30,withdrawn
570,2046,236,$13665.09,lost
571,2052,237,$15458.32,withdrawn
572,1902,237,$15616.06,won
573,1938,237,$15773.80,lost
574,1989,237,$16089.27,lost
575,2046,237,$16404.75,lost
576,2052,238,$13265.89,won
577,1902,238,$13401.26,withdrawn
578,1938,238,$13536.62,lost
579,1989,238,$13807.35,withdrawn
580,2046,238,$14078.09,lost
581,1902,239,$32083.90,withdrawn
582,2052,239,$32411.29,won
583,1938,239,$32738.68,lost
584,1989,239,$33393.45,lost
585,2046,239,$34048.22,lost
586,2052,240,$14550.69,won
587,1902,240,$14699.17,withdrawn
588,1938,240,$14847.64,lost
589,1989,240,$15144.60,withdrawn
590,2046,240,$15441.55,lost
591,2052,241,$17467.90,won
592,1902,241,$17646.15,withdrawn
593,1938,241,$17824.39,lost
594,1989,241,$18180.88,lost
595,2046,241,$18537.37,lost
596,2052,242,$14990.46,won
597,1902,242,$15143.42,withdrawn
598,1938,242,$15296.38,lost
599,1989,242,$15602.31,withdrawn
600,2046,242,$15908.24,lost
601,2052,243,$32083.90,withdrawn
602,1902,243,$32411.29,won
603,1938,243,$32738.68,lost
604,1989,243,$33393.45,lost
605,2046,243,$34048.22,lost
606,2052,244,$14550.69,won
607,1902,244,$14699.17,withdrawn
608,1938,244,$14847.64,lost
609,1989,244,$15144.60,withdrawn
610,2046,244,$15441.55,lost
611,2052,245,$17467.90,withdrawn
612,1902,245,$17646.15,won
613,1938,245,$17824.39,lost
614,1989,245,$18180.88,lost
615,2046,245,$18537.37,lost
616,2052,246,$14990.46,won
617,1902,246,$15143.42,withdrawn
618,1938,246,$15296.38,lost
619,1989,246,$15602.31,withdrawn
620,2046,246,$15908.24,lost
621,1902,247,$36254.81,withdrawn
622,2052,247,$36624.76,won
623,1938,247,$36994.71,lost
624,1989,247,$37734.60,lost
625,2046,247,$38474.49,lost
626,2052,248,$16442.28,won
627,1902,248,$16610.06,withdrawn
628,1938,248,$16777.84,lost
629,1989,248,$17113.40,withdrawn
630,2046,248,$17448.95,lost
631,2052,249,$19738.73,won
632,1902,249,$19940.15,withdrawn
633,1938,249,$20141.56,lost
634,1989,249,$20544.39,lost
635,2046,249,$20947.22,lost
636,2052,250,$16939.21,won
637,1902,250,$17112.06,withdrawn
638,1938,250,$17284.91,lost
639,1989,250,$17630.61,withdrawn
640,2046,250,$17976.31,lost
'''