####################################################################################
#                                                                                  
# Copyright (c) 2008              
#                                                                                                                      
####################################################################################
# UPDATES:
#
# STATUS: Reviewed and Approved, Matt Hillary, June 2008
#           
#
# IDEAS/QUESTIONS/NOTES:
#
#
####################################################################################

from picalo import *                            # import the Picalo libraries
import sys, re, random, os, os.path, urllib     # import commonly-used Python libraries

DETECTLET_STANDARD = 1.0

wizard = '''
<wizard>
  <page>
    Select the bid table:
    <parameter type="Table" variable="bidtable"/>
  </page>
  <page>
    Select the column in the bid table with the project ID:
    <parameter type="Column" table="bidtable" variable="projectIDcol"/>
    Select the column in the bid table that indicates if the project was 
    removed during the techincal review.  This should be a column with TRUE/FALSE.
    <parameter type="Column" table="bidtable" variable="technicalcol"/>
  </page>
  <page>
    Please enter the minimum percentage match that signals a possible
    over removal of bids.  For example, a removal rate of 30 percent or better
    typically signals a possible match.  
    <parameter type="int" min="0" max="100" default="30" variable="threshold"/>
  </page>
 </wizard>
'''

RESULTS_TEXT = '''\
    The displayed table contains the projects that meet or exceed the threshold.
'''

def run(bidtable, projectIDcol, technicalcol, threshold):
  '''Most organizations require multiple bids to increase 
  competition between suppliers. This keeps prices low and increases 
  quality.  Bids are evaluated in a technical and financial review.  The
  financial evaluation is objective and looks for the lowest bidder.  The
  technical evaluation is subjective to see if the bid will meet the quality
  standards for the project.  All bidders are aware of the technical requirements
  and most bidders design a bid up to the technical standards.
  
  During the techincal evaluation, bids can fraudulently be removed so that only one or a few
  bids go through to the financial evaluation.  This allows a company or individual to fradulently 
  select which company it wants to win the bidding process.
  
  This detectlet searches for projects that have an unusually high technical removal rate.
  '''
  
  # create the new table
  results = Table([
    ( 'Project', unicode),
    ( 'TotalBids', unicode),
    ( 'TechnicallyRemovedBids', unicode),
    ( 'RemovalPercentage', int),
  ])
    
  lastProj = 0
  totalProj = 0
  totalRemoved = 0
  percRemoved = 0
  errors = 0

  # search for projects and removed bids
  for bid in bidtable:
    if not bid[projectIDcol] ==lastProj and not lastProj==0:
        percRemoved = (totalRemoved*100/totalProj)
        if percRemoved>=threshold:
            rec = results.append()
            rec["Project"] = lastProj
            rec["TotalBids"]= totalProj
            rec["TechnicallyRemovedBids"] = totalRemoved
            rec["RemovalPercentage"] = percRemoved
            lastProj = bid[projectIDcol]
            totalProj = 0
            totalRemoved = 0
        else:
            lastProj = bid[projectIDcol]
            totalProj = 0
            totalRemoved = 0
    lastProj=bid[projectIDcol]
    totalProj+=1
    try:
        if bid[technicalcol]=="False":
            totalRemoved+=1
    except:
        errors+=1
                    
  #return
  return results, RESULTS_TEXT
  
def example_input():
  import StringIO  # to emulate a file for load_csv
  table = load_csv(StringIO.StringIO(csvdata))
  table.set_type('bid_id', int)
  table.set_type('project_id', int)
  table.set_type('vendor_id', int)
  table.set_type('passed_technical', boolean)
  table.set_type('bid_total_amount', number)
  table.set_type('winner', boolean)
  return table
# This next part is not required, but it's easier to put the example data
# directly in this file so I don't have to worry about directories.
csvdata = '''\
bid_id,project_id,vendor_id,passed_technical,bid_total_amount,winner
1,1,2,TRUE,81710,FALSE
2,1,3,TRUE,73616,TRUE
3,1,8,TRUE,78459,FALSE
4,1,4,TRUE,80154,FALSE
5,1,10,TRUE,84468,FALSE
6,1,13,TRUE,84499,FALSE
7,3,3,TRUE,79047,FALSE
8,3,9,TRUE,88832,FALSE
9,3,6,TRUE,80644,FALSE
10,3,13,FALSE,90000,FALSE
11,3,1,TRUE,77039,FALSE
12,3,14,TRUE,74475,TRUE
13,5,13,TRUE,88636,FALSE
14,5,14,TRUE,91261,FALSE
15,5,1,TRUE,92006,FALSE
18,5,13,TRUE,74107,FALSE
19,5,5,TRUE,60250,TRUE
20,5,15,TRUE,64108,FALSE
21,5,7,TRUE,64087,FALSE
22,8,2,TRUE,57121,TRUE
23,8,6,FALSE,26776,FALSE
24,8,3,FALSE,45663,FALSE
25,8,14,FALSE,87765,FALSE
26,8,10,TRUE,77389,FALSE
30,8,11,TRUE,80934,FALSE
31,8,8,FALSE,32456,FALSE
32,8,3,FALSE,38902,FALSE
33,8,6,FALSE,50965,FALSE
34,12,1,FALSE,24352,FALSE
35,12,4,FALSE,34453,FALSE
36,12,10,TRUE,72907,TRUE
37,12,9,FALSE,100112,FALSE
38,12,3,FALSE,102394,FALSE
39,12,8,FALSE,99998,FALSE
40,14,8,TRUE,83470,TRUE
41,14,6,TRUE,85833,FALSE
42,14,9,TRUE,85366,FALSE
43,15,7,TRUE,111531,FALSE
44,15,5,TRUE,111454,TRUE
47,16,9,TRUE,90398,TRUE
48,16,8,TRUE,93963,FALSE
49,17,7,TRUE,69701,TRUE
50,17,12,TRUE,72258,FALSE
51,17,15,TRUE,77042,FALSE
52,18,6,TRUE,65980,FALSE
53,18,2,TRUE,62398,TRUE
54,18,9,TRUE,66761,FALSE
55,19,1,FALSE,23432,FALSE
56,19,14,FALSE,23344,FALSE
57,19,4,TRUE,51033,TRUE
58,20,10,TRUE,94882,TRUE
59,20,14,TRUE,96371,FALSE
60,20,1,TRUE,94926,FALSE
61,21,14,TRUE,82492,FALSE
62,21,1,TRUE,74023,TRUE
66,22,15,TRUE,94699,TRUE
67,23,13,TRUE,97517,FALSE
68,23,4,TRUE,93742,TRUE
69,23,1,TRUE,97177,FALSE
70,24,11,TRUE,98032,FALSE
71,24,7,TRUE,95292,TRUE
72,24,15,TRUE,95506,FALSE
73,25,12,FALSE,102765,FALSE
74,25,7,FALSE,143534,FALSE
75,25,15,TRUE,96456,TRUE
76,26,5,TRUE,79598,FALSE
77,26,11,TRUE,78413,FALSE
78,26,15,TRUE,76724,TRUE
79,27,6,TRUE,67505,TRUE
80,27,3,TRUE,68713,FALSE
81,27,2,TRUE,72646,FALSE
82,28,11,TRUE,72019,FALSE
85,28,1,TRUE,104470,FALSE
88,28,5,TRUE,69785,FALSE
89,28,15,TRUE,66948,TRUE
90,28,11,TRUE,68492,FALSE
91,28,8,TRUE,83345,FALSE
92,28,3,TRUE,83426,FALSE
95,28,12,FALSE,34423,FALSE
96,28,15,TRUE,90266,FALSE
97,28,13,FALSE,76685,FALSE
98,28,14,TRUE,73360,FALSE
99,28,10,TRUE,78470,FALSE'''


  