####################################################################################
#                                                                                  
# Copyright (c) 2008 Travis Kulbeth <tkulbethATgmailDOTcom>               
#                                                                                  
# This deteclet is part of the Check Tampering detectlets library.                     
# It is open source and can be modified as needed.                                    
#                                                                                  
####################################################################################
# UPDATES:
#
#   April 2008  First version of the detectlet
#
# STATUS: Reviewed and Approved, Matt Hillary, June 2008
#
# IDEAS/QUESTIONS:
#
#
####################################################################################

DETECTLET_STANDARD = 1.0

from picalo import *                            # import the Picalo libraries
import sys, re, random, os, os.path, urllib     # import commonly-used Python libraries

wizard = '''
<wizard>
  <page>
    Select the TABLE containing records of checks on a bank statement. The table must contain 
    columns for check numbers and check status.
    
    <parameter type="Table" variable="bank_statement_table"/>
  </page>
  <page>
    Select the COLUMN from the bank statement table containing CHECK NUMBERS:
    
    <parameter type="Column" table="bank_statement_table" variable="check_number_col"/>
    
    Select the COLUMN from the bank statement table containing CHECK STATUS:
    
    <parameter type="Column" table="bank_statement_table" variable="check_status_col"/>
  </page>
  <page>
    Enter the text used to indicate a cancelled check (i.e. "Void" or "Cancelled")
    
    <parameter type="string" variable="cancel_flag_txt" default="Void" />
  </page>
</wizard>
'''


RESULTS_TEXT = '''
    The displayed table shows all of the checks that have been cancelled out 
    of sequence with the rest of the checks. These records may be indicators of someone 
    obtaining checks from a future set and potentially using them for fraudulent 
    purposes.
    
    The checks listed in this table should be verified. One possibility is that 
    the check stock is not locked up properly, or that those who have access 
    to the check stock are abusing that authority.  Review what checks have been 
    cleared to determine if any other activity has been going on unmonitored.  If 
    a sign of fraudulent activity exists, one solution may be to close out the account
    or change account numbers to prevent further use of out-of-sequence checks.
'''

def run(bank_statement_table, check_number_col, check_status_col, cancel_flag_txt):
    '''Check tampering has several forms, one of the most common being the use of out-of-sequence 
    checks.  The presence of cancelled checks may indicate unauthorized use of checks, fraudulent 
    checks being concealed, and/or amounts being altered.  
    
    This detectlet searches for checks that have been cancelled out of sequence (i.e., the 
    current range of checks being used is in the 200s, while a cancelled check is in the 400s set).
    
    Checks that are returned from this detectlet should be investigated. Key places to look for 
    further signs of check tampering may be through who has access to the check storage, who 
    has the authority to write and sign them, and who is responsible for bank reconciliation. As a side note, 
    these duties should always be a separated--even in the smallest organization.
    '''

    #retrieve a list of the unordered checks
    unordered_index_tbl = Simple.get_unordered(bank_statement_table, True, check_number_col)
    unordered_list = unordered_index_tbl['Unordered_Rows']
    
    #check the status of the unordered checks for cancellation
    unordered_records = Simple.select_records(bank_statement_table, unordered_list)
    results_table = Simple.select(unordered_records, "record[check_status_col] == cancel_flag_txt")   
    
    return results_table, RESULTS_TEXT
    
    
def example_input():
    import StringIO  # to emulate a file for load_csv
    table = load_csv(StringIO.StringIO(csvdata))
    table.set_type('CheckNumber', int)
    table.set_type('Amount', number)
    return table

csvdata = '''\
"Date","CheckNumber","CheckStatus","Amount"
01-02-2008,1011,"Cleared",883.00
01-02-2008,1012,"Cleared",668.00
01-03-2008,1013,"Cleared",298.00
01-03-2008,1014,"Void",87.00
01-04-2008,1015,"Cleared",25.00
01-04-2008,1016,"Cleared",459.00
01-05-2008,1017,"Cleared",473.00
01-06-2008,1018,"Cleared",956.00
01-07-2008,1019,"Cleared",92.00
01-08-2008,1020,"Cleared",602.00
01-09-2008,1021,"Cleared",24.00
01-09-2008,1022,"Cleared",843.00
01-10-2008,1023,"Cleared",839.00
01-10-2008,1024,"Cleared",946.00
01-11-2008,1025,"Cleared",942.00
01-11-2008,1026,"Cleared",21.00
01-11-2008,1417,"Void",136.00
01-11-2008,1028,"Cleared",932.00
01-13-2008,1029,"Cleared",325.00
01-14-2008,1030,"Cleared",113.00
01-15-2008,1031,"Cleared",436.00
01-16-2008,1032,"Void",225.00
01-17-2008,1033,"Cleared",947.00
01-18-2008,1034,"Cleared",994.00
01-19-2008,1035,"Cleared",221.00
01-25-2008,1036,"Cleared",926.00
01-25-2008,1037,"Cleared",651.00
01-25-2008,1038,"Cleared",718.00
01-26-2008,1039,"Cleared",914.00
01-26-2008,1418,"Void",829.00
01-26-2008,1041,"Cleared",399.00
01-27-2008,1042,"Void",797.00
01-28-2008,1043,"Cleared",497.00
01-29-2008,1044,"Cleared",697.00
01-30-2008,1045,"Cleared",885.00
01-30-2008,1046,"Cleared",522.00
01-31-2008,1047,"Cleared",157.00
02-01-2008,1048,"Cleared",359.00
02-02-2008,1049,"Cleared",479.00
02-03-2008,1050,"Cleared",249.00
02-04-2008,1051,"Cleared",962.00
02-05-2008,1052,"Void",503.00
02-06-2008,1053,"Cleared",93.00
02-06-2008,1054,"Cleared",801.00
02-06-2008,1423,"Cleared",450.00
02-06-2008,1056,"Cleared",36.00
02-07-2008,1057,"Cleared",822.00
02-08-2008,1058,"Cleared",587.00
02-09-2008,1059,"Cleared",969.00
02-10-2008,1060,"Cleared",148.00
02-10-2008,1061,"Void",700.00
02-11-2008,1062,"Cleared",405.00
02-11-2008,1063,"Cleared",373.00
02-12-2008,1064,"Cleared",648.00
02-12-2008,1065,"Cleared",399.00
02-13-2008,1066,"Cleared",594.00
02-13-2008,1067,"Cleared",575.00
02-14-2008,1068,"Cleared",51.00
02-14-2008,1421,"Void",312.00
02-15-2008,1070,"Cleared",489.00
02-15-2008,1071,"Cleared",880.00
02-15-2008,1072,"Cleared",712.00
02-15-2008,1073,"Cleared",287.00
02-15-2008,1074,"Cleared",377.00
02-16-2008,1075,"Cleared",409.00
02-16-2008,1076,"Cleared",172.00
02-16-2008,1077,"Cleared",900.00
02-16-2008,1078,"Cleared",566.00
02-17-2008,1079,"Cleared",532.00
02-18-2008,1080,"Cleared",380.00
02-19-2008,1081,"Void",816.00
02-20-2008,1082,"Cleared",494.00
02-21-2008,1083,"Cleared",884.00
02-21-2008,1387,"Void",909.00
02-22-2008,1085,"Cleared",295.00
02-23-2008,1086,"Cleared",335.00
02-24-2008,1087,"Cleared",946.00
02-25-2008,1088,"Cleared",118.00
02-26-2008,1089,"Cleared",922.00
02-27-2008,1090,"Void",915.00
02-28-2008,1091,"Cleared",266.00
02-29-2008,1092,"Cleared",623.00
03-01-2008,1093,"Cleared",320.00
03-01-2008,1192,"Cleared",640.00
03-01-2008,1095,"Cleared",272.00
03-01-2008,1096,"Cleared",719.00
03-02-2008,1097,"Void",235.00
03-02-2008,1098,"Cleared",847.00
03-03-2008,1099,"Void",771.00
03-04-2008,1100,"Cleared",547.00
03-05-2008,1101,"Cleared",337.00
03-06-2008,1102,"Cleared",651.00
03-07-2008,1427,"Void",260.00
03-08-2008,1104,"Cleared",625.00
03-08-2008,1105,"Cleared",29.00
03-08-2008,1106,"Cleared",669.00
03-09-2008,1107,"Cleared",797.00
03-09-2008,1108,"Void",929.00
03-10-2008,1109,"Cleared",236.00
03-11-2008,1110,"Cleared",329.00
'''
    
