####################################################################################
#                                                                                  
# Copyright (c) 2008 Charles Brown
#                                                                                  
# Detectlet: Check for Employees with dead Social Security Numbers 
#                                                                                  
####################################################################################
# UPDATES:
#
# STATUS: Reviewed and Approved. Did not test with database connection. Matt Hillary, June 2008
#
# IDEAS/QUESTIONS:
#   
#
####################################################################################

from picalo import *                            # import the Picalo libraries
import sys, re, random, os, os.path, urllib     # import commonly-used Python libraries

DETECTLET_STANDARD = 1.0

wizard = '''
<wizard>
    <page>
        Select the TABLE that has your employee information.  There must be 
        a SSN column in this table, which you will have to select on the
        next page.
        
        <parameter type="table" variable="employeeTable" />
    </page>
    <page>
        Select the COLUMN in the employee table that contains the social
        security numbers. 
        
        <parameter type="column" table="employeeTable" variable="employeeSSN" />        
    </page>
    <page>
        Select the DATABASE connection that contains the death index table.
        
        <parameter type="database" variable="theDatabase" />
    </page>
    <page>
        Enter the name of the TABLE WITHIN THE DATABASE you just chose that contains
        the dead social security numbers.  
        
        <parameter type="string" variable="theTableName" />
        
        Enter the COLUMN NAME in the table you just chose that contains the social 
        security numbers.  These are the numbers that the employees' SSN will
        be checked against.
        
        <parameter type="string" variable="theCol" />
    </page>
</wizard>
'''
def createNewTableFromOldAndPopulate(tbl, lst):
    return populateTableFromList(createNewTableFromOld(tbl), lst)

def populateTableFromList(tbl, lst):
    for rowNum in range(0, len(lst)):    
        row = lst[rowNum]
        tbl.append()
        for colIdx in range( len(row)):            
            tbl[rowNum][colIdx] = lst[rowNum][colIdx]
    
    return tbl
    
    
    
def createNewTableFromOld(oldTable):
    #build a table of the flagged rows and return it   
    #create a new table out of the valid rows
    namesAndType = []
    for col in oldTable.get_columns():
        namesAndType.append(col.name)
        namesAndType.append(col.get_type())       
    
    res = Table()
    res.delete_column(0)
    res.delete_column(0)
    res.delete_column(0)
    
    for idx in range(0, len(namesAndType), 2):
        name = namesAndType[idx]
        type = namesAndType[idx+1]
        if(type == None):
            type = unicode
            
        res.append_column(name, type)
        
    return res
    
    

def run(theDatabase, theTableName, theCol, employeeTable, employeeSSN):
    '''This Detectlet checks employees' Social Security Numbers against
    a database of bad numbers (usually a Death Index or Master Death File provided 
    by the Government or other SSN entity).
    
    **NOTE: YOU MUST HAVE A DATABASE CONNECTION ALREADY SET UP BEFORE RUNNING
    THIS DETECTLET. (see the Picalo documentation on how to make a 
    database connection).
 
    For more information on purchasing the most current database of Social
    Security Numbers registered to persons who are dead, see the Social
    Security Administration's website. (http://www.ssa.gov)   
    '''

    ssnTable = theDatabase.table("SELECT " + theCol + " FROM " + theTableName)

    ssnums = ssnTable[theCol]
    
    badSSNs = []
    
    for deadNum in ssnums:
    
        for employeeRecIdx in range(len(employeeTable)):        
        
            if(deadNum == employeeTable[employeeRecIdx][employeeSSN.name]):
            
                badSSNs.append(employeeTable[employeeRecIdx])
    
    newTable = createNewTableFromOldAndPopulate(employeeTable, badSSNs)
        
    return newTable, "This table represents all the employee social security numbers that are actually registered to a person who has died."

def example_input():
    import StringIO
    table = load_csv(StringIO.StringIO(csvdata))
    table.set_type("SSNumber", unicode)
    table.set_type("firstname", unicode)
    table.set_type("lastname", unicode)    
    
    return table
    
csvdata = '''\
SSNumber,firstname,lastname
585-63-4226, Charles, Brown
232-12-1234, George, Weesley
123-12-1234, Fred, Weesley
234-56-7890, Molly, Weesley
345-67-8901, Arthur, Weesley
456-78-9012, Ginny, Weesly
567-89-0123, Ron, Weesly
678-90-1234, Harry, Potter
789-01-2345, Hermione, Grainger
890-12-3456, Z, Jay'''

if __name__ == "__main__":
    theTable = example_input()
    newTable, resTxt = run(ODBCMySQLConn, 'ssndeathindex', 'ssn', theTable, theTable['SSNumber'])
