#!/usr/bin/python

####################################################################################
#                                                                                  #
# Copyright (c) 2005 Dr. Conan C. Albrecht <conan_albrechtATbyuDOTedu>             #
#                                                                                  #
# This file is part of Picalo.                                                     #
#                                                                                  #
# Picalo is free software; you can redistribute it and/or modify                   #
# it under the terms of the GNU General Public License as published by             #
# the Free Software Foundation; either version 2 of the License, or                # 
# (at your option) any later version.                                              #
#                                                                                  #
# Picalo is distributed in the hope that it will be useful,                        #
# but WITHOUT ANY WARRANTY; without even the implied warranty of                   #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                    #
# GNU General Public License for more details.                                     #
#                                                                                  #
# You should have received a copy of the GNU General Public License                #
# along with Foobar; if not, write to the Free Software                            #
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA        #
#                                                                                  #
####################################################################################
#
# 16 Dec 2009 First version
#
####################################################################################

import wx, wx.html


def show(parent, title, htmltext, size=(350, 400)):
  '''Shows a minihelp dialog'''
  mh = MiniHelp(parent, title, htmltext, size=size)
  mh.ShowModal()


class MiniHelp(wx.Dialog):
  '''Shows a small mini-help dialog to show hints or short help text to the user'''
  def __init__(self, parent, title, htmltext, size=(350, 400), style=wx.DEFAULT_FRAME_STYLE):
      wx.Dialog.__init__(self, parent, title=title, size=size, style=style)
      self.CenterOnScreen()
      self.SetSizer(wx.BoxSizer(wx.VERTICAL))
      sizer = wx.BoxSizer(wx.VERTICAL)
      self.GetSizer().Add(sizer, flag=wx.EXPAND | wx.ALL, proportion=1, border=7)

      # add the html control
      html = wx.html.HtmlWindow(self)
      html.SetPage(htmltext)
      sizer.Add(html, flag=wx.EXPAND | wx.ALL, proportion=1)
  
      # close button
      sizer.AddSpacer(10)
      closebutton = wx.Button(self, label="Close") 
      sizer.Add(closebutton, flag=wx.ALIGN_CENTER_HORIZONTAL)

      # events
      self.Bind(wx.EVT_BUTTON, self.OnCloseMe, closebutton)
      self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)

  def OnCloseMe(self, event):
      self.Close(True)

  def OnCloseWindow(self, event):
      self.Destroy()  
      
      

