#!/usr/bin/python

####################################################################################
#                                                                                  #
# Copyright (c) 2005 Dr. Conan C. Albrecht <conan_albrechtATbyuDOTedu>             #
#                                                                                  #
# This file is part of Picalo.                                                     #
#                                                                                  #
# Picalo is free software; you can redistribute it and/or modify                   #
# it under the terms of the GNU General Public License as published by             #
# the Free Software Foundation; either version 2 of the License, or                # 
# (at your option) any later version.                                              #
#                                                                                  #
# Picalo is distributed in the hope that it will be useful,                        #
# but WITHOUT ANY WARRANTY; without even the implied warranty of                   #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                    #
# GNU General Public License for more details.                                     #
#                                                                                  #
# You should have received a copy of the GNU General Public License                #
# along with Foobar; if not, write to the Free Software                            #
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA        #
#                                                                                  #
####################################################################################
#
# 12 Sep 2005 First version
#
####################################################################################

import optparse
import picalo.gui.Utils
import sys, os.path, os


# The Windows Picalo log file can get very large, so delete it to start over each time
# we start Picalo
if os.path.exists(os.path.join(picalo.gui.Utils.APPDIR, 'Picalo.exe.log')):
  try:
    os.remove(os.path.join(picalo.gui.Utils.APPDIR, "Picalo.exe.log"))
  except:
    print >> sys.stderr, "Could not delete Picalo.exe.log"

# parse the command line options
optparser = optparse.OptionParser()
optparser.add_option("-n", "--nosplash", action="store_false", dest="splash", default=True, help="don't show the splash screen at startup")
optparser.add_option("-s", "--script", action="store", dest="script", type="string", metavar="<script>", help="run the given script file at startup")
options, args = optparser.parse_args()

# reset the arguments for scripts that we run
sys.argv = sys.argv[0:1]

# creates the application
import picalo.gui.PicaloApp
app = picalo.gui.PicaloApp.PicaloApp(options)
app.MainLoop()

