#!/usr/bin/python

'''
Updates the language files with the text from the program.
This script searches through all python files in the program
and finds the lang('...') text.  It saves any new strings found
to the language files in the resources directory.
'''

import re, os.path, codecs
from picalo.gui import Utils
from picalo.gui import Languages

# go through all the python files
print 'Gathering strings from python files...'
strings = {}
re_lang1 = re.compile('''lang\(['"](.*?)['"]\)''')
re_lang2 = re.compile('''lang\(['"]{3}(.*?)['"]{3}\)''')
for root, dirs, files in os.walk('./picalo/gui/'):
  for file in files:
    fname, ext = os.path.splitext(file)
    if ext == '.py':
      fullname = os.path.join(root, file)
      f = open(fullname)
      code = f.read()
      f.close()
      for match in re_lang1.findall(code) + re_lang2.findall(code):
        strings[match] = None  # to get rid of duplicates
        

# go through the resource file
f = open(Utils.getResourcePath('dialogs.xrc'))
xml = f.read()
f.close()
for tag in [ 'title', 'label', 'value' ]:
  for match in re.findall('<' + tag + '>(.*?[a-zA-Z].*?)</' + tag + '>', xml):
    strings[match] = None

  
# go through each language file
print 'Updating language files...'
for language in Utils.getLanguages():
  print '\t', language
  # load this file into the dictionary
  lang = Languages.LanguageFile(language)
  
  # add any new strings from Picalo that are not in the language file
  for key, value in strings.items():
    if not key in lang:
      lang[key] = value
      
  # delete any keys that are in the language file that are no longer in Picalo
  for key in lang.keys():
    if not key in strings:
      del lang[key]
      
  # remove any values that exactly match their key (so the translator can see them as empty)
  for key in lang.keys():
    if key == lang[key]:
      lang[key] = None
      
  # sort first by the ones not done yet, then by alphabetical
  def comparekeys(a, b):
    hasa = lang.has_explicit_key(a)
    hasb = lang.has_explicit_key(b)
    if hasa and hasb:
      return cmp(a.lower(), b.lower())
    elif hasa:
      return 1
    elif hasb:
      return -1
    return cmp(a.lower(), b.lower())
  keys = lang.keys()
  keys.sort(comparekeys)

  # save the dictionary
  f = codecs.open(Utils.getResourcePath(language + '.language'), 'w', 'ISO-8859-1')
  for st in keys:
    print >> f, st
    print >> f, ''
    if lang.has_explicit_key(st):
      print >> f, lang[st]
    else:
      print >> f, ''
    print >> f, ''
    print >> f, ''
    print >> f, ''
    print >> f, ''
  f.close()
