#!/usr/bin/env python

####################################################################################
#                                                                                  #
# Copyright (c) 2006 Dr. Conan C. Albrecht <conan_albrechtATbyuDOTedu>             #
#                                                                                  #
# This file is part of Picalo.                                                     #
#                                                                                  #
# Picalo is free software; you can redistribute it and/or modify                   #
# it under the terms of the GNU General Public License as published by             #
# the Free Software Foundation; either version 2 of the License, or                # 
# (at your option) any later version.                                              #
#                                                                                  #
# Picalo is distributed in the hope that it will be useful,                        #
# but WITHOUT ANY WARRANTY; without even the implied warranty of                   #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                    #
# GNU General Public License for more details.                                     #
#                                                                                  #
# You should have received a copy of the GNU General Public License                #
# along with Foobar; if not, write to the Free Software                            #
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA        #
#                                                                                  #
####################################################################################

from picalo.gui import Editor
from picalo.gui import Utils
from picalo.gui import Dialogs
from picalo.gui import Spreadsheet
from picalo.gui.PicaloWizard import PicaloWizard, _load_module
from picalo.gui.Languages import lang
from picalo.lib import GUID
import wx, wx.wizard
import imp, re, traceback, os.path, zipfile, sys
import xml.dom.minidom
from StringIO import StringIO
import types
from picalo import Table, TableArray, TableList
from picalo.base.Global import clear_progress, make_valid_variable


# our reference to the main frame of the application
mainframe = None


#############################################################
###   Required plugin variables and methods

PLUGIN_VERSION = 1.0

def initialize_plugin(mf):
  '''Called to initialize this plugin.'''
  global mainframe
  mainframe = mf
  

def get_menu_items():
  '''Returns the menu items for this plugin.  This method returns
     a list of Utils.MenuItem objects'''
  items = menuitems[:]
  for packages, filename, wizard in findDetectlets():
    menuparts = [ re.sub(r'(?<=.)((?<=[^A-Z])([A-Z])|([A-Z])(?=[^A-Z]))', r' \1', package) for package in packages + [ wizard ] ]
    items.append(Utils.MenuItem(lang('&Tools') + '/' + lang('Detectlets') + '/' + '/'.join(menuparts), lang('Run the') + ' ' + wizard + ' ' + lang(' Wizard'), PicaloWizard(mainframe, filename, wizard)))
  return items


#detectlets_dir = os.path.join(Utils.APPDIR, 'picalo', 'tools', 'Detectlets')
detectlets_dir = os.path.split(sys.modules[globals()['__name__']].__file__)[0]
def findDetectlets():
  '''Returns the Python files in the wizards directory'''
  d = []
  for root, dirs, files in os.walk(detectlets_dir):
    files.sort(lambda a,b: cmp(a.lower(), b.lower()))  # so .py files come before .pyc -- we give source files preference
    usedfnames = []
    for file in files:
      fname, ext = os.path.splitext(file)
      if ext in ['.py', '.pyc'] and not fname in usedfnames and not file[:1] in ('_', '.'):
        usedfnames.append(fname)
        # split the directory into its parts (starting with the wizard directory)
        packages = []
        head = root[len(detectlets_dir)+1:]
        while head != '':
          head, tail = os.path.split(head)
          packages.insert(0, tail)
        wizard = os.path.splitext(file)[0]
        filename = os.path.join(root, file)
        d.append([ packages, filename, wizard ])
  return d


#############################################################
###   Menu methods


def menuInstall(event):
  '''Installs new detectlets into the program'''
  dlg = wx.FileDialog(mainframe, message=lang("Install Detectlet Library"), defaultDir=os.getcwd(), defaultFile="", style=wx.OPEN | wx.CHANGE_DIR | wx.FILE_MUST_EXIST)
  if dlg.ShowModal() == wx.ID_OK:
    filename = dlg.GetPath()
    os.chdir(os.path.split(filename)[0])
    libraryext = os.path.splitext(filename)[1].lower()
    files = []
    if libraryext in [ '.py', '.pyc' ]:
      files.append((os.path.split(filename)[1], filename))
    elif libraryext == '.zip':
      # since load_module requires *real* files, we have to temporarily save the zip entries to real files, then delete
      while 1:  # ensure it doesn't exist so we don't blast something already there
        tempdir = os.path.join(Utils.getHomeDir(), GUID.generate())
        if not os.path.exists(tempdir):
          break
      zf = zipfile.ZipFile(filename)
      for fname in zf.namelist():
        if os.path.splitext(fname)[1].lower() in [ '.py', '.pyc' ]:
          fullname = os.path.join(tempdir, fname)
          if not os.path.exists(os.path.split(fullname)[0]):
            os.makedirs(os.path.split(fullname)[0])
          fout = open(fullname, 'w')
          fout.write(zf.read(fname))
          files.append((fname, fullname))
    else:
      wx.MessageBox(lang('Only .py, .pyc, and .zip files can be loaded.'), lang('Picalo'), wx.OK | wx.ICON_ERROR)
      return
      
    # copy all valid detectlets
    installed = {}
    files.sort(lambda a,b: cmp(a[0].lower(), b[0].lower())) # ensures .py files come before .pyc files
    for filename, fullname in files:
      detectletpath = os.path.splitext(filename)[0]
      head, tail = os.path.split(fullname)
      detectlet, ext = os.path.splitext(tail)
      if not installed.has_key(detectletpath):  # if the zip contains both .py and .pyc files, only install the .py
        try:
          # ensure we have a valid detectlet
          _load_module(detectlet, fullname)
          # copy it into the detectlets directory
          newname = os.path.join(detectlets_dir, filename)
          if not os.path.exists(os.path.split(newname)[0]):
            os.makedirs(os.path.split(newname)[0])
          fin = open(fullname)
          fout = open(newname, 'w')
          fout.write(fin.read())
          fout.close()
          fin.close()
          installed[detectletpath] = None
        except Exception, e:
          wx.MessageBox(str(e), lang('Error on') + ' ' + detectlet, wx.OK | wx.ICON_ERROR)
          continue
        
    # delete the created directory if a zip file
    if libraryext == '.zip':
      for root, dirs, files in os.walk(tempdir, topdown=False):
        for name in files:
            os.remove(os.path.join(root, name))
        for name in dirs:
            os.rmdir(os.path.join(root, name))
      os.rmdir(tempdir)
   
    # reload the menu
    wx.MessageBox(str(len(installed)) + ' ' + lang('new Detectlet(s) were installed.'), lang('Install Detectlet Library'), wx.OK | wx.ICON_INFORMATION)
    mainframe.updateMenu(refresh_plugins=True)
  

  
def menuRunScriptAsDetectlet(event):
  '''Runs a script open in the script editor in the deteclet wizard (useful for debugging detectlets)'''
  # get the editor page
  page = mainframe.getCurrentPage()
  assert isinstance(page, Editor.Editor), lang('You need to open a detectlet ".py" script into Picalo before running this menu option.  Alternatively, you can install the detectlet so it shows up on your menu.')
  assert page.filename, lang('Please save this file before running it as a detectlet.')
  page.menuFileSave()
  
  # run the wizard
  title = os.path.splitext(os.path.split(page.filename)[1])[0]
  wiz = PicaloWizard(mainframe, page.filename, title)
  wiz()
  
  
  
####################################################################################
###   The menu items array (must come after the function definitions)

menuitems = [
  Utils.MenuItem(lang('&Tools') + '/' + lang('Detectlets') + '/' + lang('Install New Library...'), lang('Install a new tool set'), menuInstall),
  Utils.MenuItem(lang('&Tools') + '/' + lang('Detectlets') + '/' + lang('Run Script In Detectlet Wizard...'), lang('Run a script opened in the script editor as a detectlet'), menuRunScriptAsDetectlet),
  Utils.MenuItem(lang('&Tools') + '/' + lang('Detectlets') + '/SEPARATOR'),
]


    
