####################################################################################
# 
# Created By: Matt Hillary
# Date: April 23, 2008                            
#
#
#
# Copyright (c) 2008 Matt Hillary <matt.hillaryATgmailDOTcom               
# 
# It requires a license and is not open source.                                    		       
#                                                                                  
####################################################################################
# UPDATES
#
####################################################################################
# STATUS: PRODUCTION
# 
# IDEAS/QUESTIONS/NOTES:
#
#
####################################################################################
DETECTLET_STANDARD = 1.0

from picalo import *

wizard = '''
<wizard>
  <page>
    Select the TABLE containing CONTRACT PRICES for PARTS/PRODUCTS/SUPPLIES:
    
    <parameter type="Table" variable="cptable"/>

    Select the TABLE containing PURCHASE LINE ORDERS:
    
    <parameter type="Table" variable="plotable"/>
  </page>
  <page>
    Select the COLUMN identifying the ID of the PART/PRODUCT/SUPPLY:
    
    <parameter type="Column" table="cptable" variable="part_id_column1"/>

	Select the COLUMN identifying the CONTRACT PRICE of the PART/PRODUCT/SUPPLY:

    <parameter type="Column" table="cptable" variable="contract_price_column"/>

   </page>
   <page>
    Select the COLUMN identifying the VENDOR ID of the PART/PRODUCT/SUPPLY:
    
    <parameter type="Column" table="cptable" variable="vendor_id_column"/>

	Select the COLUMN identifying the PURCHASE ORDER ID of the PURCHASE LINE:

    <parameter type="Column" table="plotable" variable="purchaseorderid_column"/>

   </page>
   <page>
    Select the COLUMN identifying the PART NUMBER of the PART/PRODUCT/SUPPLY on the PURCHASE LINE ORDER:
    
    <parameter type="Column" table="plotable" variable="part_id_column2"/>

	Select the COLUMN identifying the QUANTITY of the ORDERED PART:

    <parameter type="Column" table="plotable" variable="quantity_column"/>

   </page>
   <page>
    Select the COLUMN identifying the TOTAL PRICE of the ORDER LINE ITEM:
    
    <parameter type="Column" table="plotable" variable="total_price_column"/>

   </page>
 </wizard>
'''

RESULTS_TEXT = '''The presented table shows the a list of all vendors who are hiking prices on specific products.
The vendor id, part number, contract price, invoice price, and invoice number of vendor hiking prices.
'''

def run(cptable, plotable, part_id_column1, contract_price_column, vendor_id_column, purchaseorderid_column, part_id_column2, quantity_column, total_price_column):
  '''Companies may choose to initiate a contract with a vendor on supplies
  used on a regular basis. These vendors may try to "hike" the prices of their 
  supplies on the invoices to a price slightly higher and not easily noticable 
  to the buyer. 

  This detectlet compares the unit price on purchase line orders for each product with contract
  prices for the product. The results are displayed in a results table showing the part numbers, 
  contract prices, purchase order line unit prices, and vendor IDs for those vendors hiking their 
  prices during the contract period.
  '''
  
  # run the analysis
  results = Table([
    ('VendorID', int),
    ('PartNumber', unicode),
    ('ContractPrice', unicode),
    ('InvoicePrice', unicode),
    ('InvoiceNumber', unicode),
    ])
  
  ordercounter = 0
  
  for orderline in plotable:
    partnumber = plotable[ordercounter][part_id_column2]
    unitprice = float(plotable[ordercounter][total_price_column])/float(plotable[ordercounter][quantity_column])
    partcounter = 0
    for part in cptable:
      if str(cptable[partcounter][part_id_column1]) == str(partnumber):
        if not unitprice == float(cptable[partcounter][contract_price_column]):
          rec = results.append()
          rec['VendorID'] = cptable[partcounter][vendor_id_column]
          rec['PartNumber'] = cptable[partcounter][part_id_column1]
          rec['ContractPrice'] = cptable[partcounter][contract_price_column]
          rec['InvoicePrice'] = unitprice
          rec['InvoiceNumber'] = plotable[ordercounter][purchaseorderid_column]
      partcounter += 1
    ordercounter += 1
    show_progress('Analyzing...', float(ordercounter) / len(part_id_column2))
    
  return results, RESULTS_TEXT

 
def example_input():
  import StringIO  # to emulate a file for load_csv
  table = load_csv(StringIO.StringIO(csvdata))
  table.set_type('PartNumber', int)
  table.set_type('Description', unicode)
  table.set_type('ContractPrice', unicode)
  table.set_type('SupplierID', unicode)

  table2 = load_csv(StringIO.StringIO(csvdata2))
  table2.set_type('PurchaseOrderNumber', int)
  table2.set_type('PartNumber', unicode)
  table2.set_type('Quantity', unicode)
  table2.set_type('Price', unicode)
  
  return table, table2

  
# This next part is not required, but it's easier to put the example data
# directly in this file so I don't have to worry about directories.
csvdata = '''\
PartNumber,Description,ContractPrice,SupplierID
354,1/4 Hex Castle Nut,0.05,22445
365,5/8 Hex Castle Nut,0.05,22445
375,Size 6 Torx Drive Flat Head Screw,0.04,16167
386,Size 10 Torx Drive Flat Head Screw,0.04,16167
397,Size 6 Flat Head Screw,0.04,16167
402,Size 10 Flat Head Screw,0.05,16167
415,Size 8 Self Tap Screw,0.07,16167
422,Size 11 Self Tap Screw,0.08,16167
436,3/16 Hex Spacer,0.01,98808
447,1/4 Hex Spacer,0.01,98808
455,Type D Wing Screws,0.09,75685
463,Weld Nut,0.08,22445
478,Clevis Pin,0.01,32243
489,J Type Spring Nut,0.06,22445
499,Coupling Nut,0.04,22445
'''

csvdata2 = '''\
PurchaseOrderNumber,PartNumber,Quantity,Price
9044,354,230,11.50 
9045,365,230,11.50 
9046,375,280,11.20 
9047,386,240,9.60 
9048,397,330,13.20 
9049,402,110,5.50 
9050,415,210,15.67 
9050,422,840,67.20 
9050,436,440,4.40 
9051,447,310,3.10 
9052,455,410,36.90 
9053,463,320,25.60 
9053,478,1200,12.00 
9053,489,640,38.40 
9054,499,680,27.20 
9054,354,230,11.50 
9054,365,230,11.50 
9055,375,280,11.20 
9056,386,240,9.60 
9057,397,330,13.20 
9057,402,110,5.50 
9058,415,210,16.70 
9059,422,840,67.20 
9059,436,440,4.40 
9060,447,310,3.10 
9061,455,410,36.90 
9061,463,320,25.60 
9062,478,1200,12.00 
9063,489,640,38.40 
9063,499,680,27.20 
9063,354,230,11.50 
9064,365,230,11.50 
9064,375,280,11.20 
9064,386,240,9.60 
9065,397,330,13.20 
9066,402,110,5.50 
9067,415,210,18.00 
9068,422,840,67.20 
9068,436,440,4.40 
9068,447,310,3.10 
9069,455,410,36.90 
9070,463,320,25.60 
9071,478,1200,12.00 
9072,489,640,38.40 
9073,499,680,27.20
'''