####################################################################################
#
# Name: Westin Hatch
# Email: <westinATbyuDOTedu>
# 
####################################################################################
# UPDATES
# 14 April 2008   First edition of this detectlet
#
####################################################################################
# STATUS: PRODUCTION
#
#   IDEAS/QUESTIONS/NOTES:
#
#
####################################################################################
DETECTLET_STANDARD = 1.0

from picalo import *

# The wizard asks for two variables from two tables which are passed into the run
# method. Those variables are:
#
#    1) The table where the payment data is stored
#    2) The column in the payment table that contains the vendor ID numbers
#    3) The table where the vendor data is stored
#    4) The column in the vendor table that contains the vendor ID numbers
  
wizard = '''
<wizard>
  <page>
    Select the TABLE containing the payments data for the company:
    
    <parameter type="Table" variable="payTable"/>
  </page>
  <page>
    Select the COLUMN in the payments table identifying the vendor ID number:
    
    Your payments table should contain a column for the vendor ID number. It 
    should be a nine-digit number. The format with dashes does not matter
    (XX-XXX-XXXX or XXX-XX-XXXX or XX-XXXXXXXXX).
    (Example:VendorID, VendorNumber, VenID, VendNum)
    <parameter type="Column" table="payTable" variable="venpay_id_col"/>
  </page>
  <page>
    Select the TABLE containing the vendor data for the company:
    
    <parameter type="Table" variable="venTable"/>
  </page>
  <page>  
    Select the COLUMN identifying the vendor ID numbers: 
    
    Your vendor table should contain a column for the vendor ID numbers.  
    
    It should also be a nine-digit number.
    
    (Example:VendorID, VendorNumber, VenID, VendNum)
    <parameter type="Column" table="venTable" variable="venven_id_col"/>
  </page>
</wizard>
'''


# This text will be displayed in a window of its own once the results
# are returned.
RESULTS_TEXT = ''''''

# '''The resulting table from this detectlet contains all
# vendor numbers from the payment table that were not on the vendor list.
# Further investigation might be needed to be absolutely that the vendor
# numbers in the results table are fraud, but most likely they are and any
# follow-up shouldn't take to much time or be too difficult.'''


# This is the main function where the algorithm and logic for the program
# is embedded.
def run(payTable, venTable, venpay_id_col, venven_id_col):
  '''A common fraud is for employees to make sales to friends or to set up
  a fake vendor and shuffle it into the records without anyone knowing while
  all the time the vendor is not providing much service and receiving funds.
  This fraud makes checking the vendor list very important.
  
  Usually companies only put approved vendors into their vendors list. These
  are vendors that have been verified and authorized for the company to
  transact with. Normally a company has strict policies to prevent the fraud
  of fake vendors. It is still a common fraud however.
  
  This detectlet will match all the payments a company has made to its vendors
  against the vendors list and show any vendors that were not on the vendor
  list. A vendor not on the list is likely to be fraud though other reasons
  for this anomily might be possible such as an incorrectly entered vendor
  number. Still, generally this test is a strong indicator of fraud.
  '''
  # validate the data
  #TODO:
  assert venpay_id_col != None and venpay_id_col != "" and venven_id_col != "" and venven_id_col != None, 'Your selectioned table/columns are invalid \
  or else some data is absent within them.'
  
  # create the skeleton of the table to contain the results
  results = Table([
    ( 'VendorNumber', int),
  ])
  
  # This is the basic algorithm of the whole detectlet. The test variable if true
  # means that the vendor number is on the approved vendor list.
  test = False  
  for rec in payTable:
    # In each iteration (or for each record) the vendor table is iterated to see
    # if indeed the vendor number is in the vendor table
    for rec2 in venTable:
      # If the vendor number is in the vendor table, then the test variable is
      # switched to true otherwise it stays false. The numbers are changed to
      # strings so as to be sure they have matching data type.
      if int(rec[venpay_id_col]) == int(rec2[venven_id_col]):
        test = True
        break
    # If the variable never was changed to true (meaning it never was found in the
    # vendor table) then the vendor ID is attached to the results table
    if test == False:
      results.append([rec[venpay_id_col]])
    # test is reset to False otherwise all future record will test true
    test = False
      
  # Now the table full of results is returned
  return results, RESULTS_TEXT


# There are two required tables for this detectlet to work so two table
# are returned in the example data
def example_input():
  import StringIO  # to emulate a file for load_csv
  table1 = load_csv(StringIO.StringIO(csvdata1))
  table1.set_type(0, unicode)
  table2 = load_csv(StringIO.StringIO(csvdata2))
  table2.set_type('PaidVendorNumber', int)
  return table1, table2



# This next part is not required, but it's easier to put the example data
# directly in this file so I don't have to worry about directories.
csvdata1 = '''\
VendorNumber
525797927
499808869
427556449
511319871
678696342
310307575
870843640
829710175
710150697
995204515
916730511
941291649
902468319
893719688
540410346
235904338
836979806
878185306
223250582
758617581
276861922
680087798
210765435
754558025
770690135
934660459
259674472
502937530
438715820
741216062
150961130
988156323
179074105
915843097
128217518
880875883
374422707
543174168
357551830
151546000
231930611
336078208
554271055
781031055
708849725
231427518
558426738
713876215
525789855
992562869
908508550
183804370
113460691
322968077
715072098
613947398
197288119
928090636
626094666
588229987
164442663
523989589
285270340
753103435
462284314
804061739
283946019
388186732
406273604
844141039
447665775
229568780
400053808
897476018
263812778
162562421
542015661
447590221
782365725
285491983
397412791
909586904
928526677
689650168
246631411
259547201
112980226
886535194
158875449
251570826
113248342
659533012
866911919
662233815
991805269
203826257
741648906
449005273
752620690
152203167
522274939
714367777
924905899
291996167
405086414
520945400
365372234
134872283
361143684
616559472
477684528
981471654
926107406
652168236
955698889
717200825
111131433
484730022
394485428
347003001
698794964
792249159
552860462
541751449
444421019
358693479
702728228
749184972
839486304
359619740
927805878
542336958
262464293
128412527
895651435
694088597
178467723
886388787
973636131
592934502
791157945
817606962
712177622
464728983
142647932
485946245
653677500
382315767
367522599
997506134
743200458
152575187
178045098
128704667
474736950
924824537
257270426
152809355
198296021
400495745
212844255
601824455
244239507
187131573
592591823
717771887
470663798
753344341
153862001
818817315
286741811
281089508
796830921
190454879
161094021
775326286
407479709
574640595
327976700
709888862
144524861
759982194
927579683
954622635
283868034
213373137
695735225
355385982
335573896
904134664
653492481
743396434
114786596
915586941
987408606
364340820
856389014
704501960
626052085
814289645
181385675
113966710
672287294
302550469
282737983
365985724
594261360
392707866
870840912
783010014
427094400
600913428
689945583
715746607
664690583
691346033
184257727
532482195
480851135
724098408
465353921
411154932
276047512
462463007
418173753
529645179
703750819
765771794
366464020
405895468
258273875
496952198
388984379
602941644
392292245
537073604
341695135
192718934
878405113
494261362
219861063
157905860
848627932
291797508
586458588
179532916
203035916
925461380
254836912
943353431
150035716
720585441
460131039
771310185
222810561
939161658
745509366
115621593
199919210
532561532
444685460
489729609
655901204
879979051
722834822
564878661
218683106
970645517
504371608
933472289
388299500
804029133
683264747
489161327
188966836
160330445
145979638
667461223
865329581
104367235
554132252
431980009
873299754
125064219
266724584
496004663
612305652
526109541
657990937
822333102
478178369
584222036
316003344
247212071
826092145
519766617
296818035
663346078
632093153
875060677
511639099
682479597
968011385
812349019
393948567
399384375
950454294
457606596
118417595
709767775
987392133
408234083
501003396
929293361
909480855
649584402
551970465
654020594
933563874
680945932
715886743
972207220
843993109
132705195
798777908
731108261
901187282
830474627
531321974
773186917
252209086
373471465
177590142
509923119
251988714
484722510
395819776
250733397
112216257
774299264
510798041
820616896
853757352
144800123
597067739
910255203
269184486
805768107
147419334
982880191
874192592
180778463
311010926
603873640
825888669
174628533
833454785
547063929
628914120
199413846
155428348
613036511
708418710
472154660
899907715
228601172
515534671
714636492
210277151
121922670
217719808
688065423
770785670
224404663
799370788
972454130
198439362
124635513
730413640
440850352
407467437
778456783
310249470
903107254
384634764
144170779
516844235
741747102
437936304
530612037
162094286
642525308
398622231
634694482
934864325
425283059
453285975
347798689
841587221
249404549
915758506
111458586
968621073
477667167
842616338
978045737
656929291
502490199
725123574
108881721
452043318
213526719
245966804
171118650
425608020
354484504
571861407
334525571
216379534
902501882
283026595
989265605
363284822
513971364
747899110
430178768
385595442
930160636
910938035
483129725
709407136
188351629
868758556
849544580
975685140
980941529
909780730
863722017
770081605
678437148
214146827
841102316
992190328
814918064
882302410
751252264
835761258
884279718
443692003
544480041
974130595
290728783
223264707
970729936
853920997
797040303
807860183
354696801
346237487
404509713
808918318
260020510
294416449
918142219
912490009
837032464
328805100
500713142
968855393
441286971
473021141
990129100
141081425
215581876
644490863
363610871
195624996
628877553
644303522
747171165
289517158
397637075
528580824
181616525
997964366
463907783
710508319
672322525
519122723
253501867
587410847
204715105
616256159
430728323
760578387
209594266
882822743
280343056
339265779
622078372
142542304
344768749
877765104
266847394
590058042
991255617
628134237
173107892
629037133
594639629
113085533
383593621
681273563
714175933
551469302
164297223
217389374
347967690
148341639
527230617
111367222
222802484
207921570
517086597
728519977
975004717
464624489
989903856
387675905
485836938
632286348
238210743
762093932
256229703
711436219
985181546
483621187
981068560
931190218
421141133
639061605
158414051
851182933
956666434
650655814
106749497
440520185
550935897
749330344
106832897
543418451
541923916
861744838
801692869
758893104
249679936
455719701
251360545
808356790
751215146
409040000
541924757
286398683
163765584
153501038
198118340
552017627
709758335
935239579
827863788
656136045
210456086
754396023
367934448
244844129
143585069
921434565
799475664
585519674
485633178
603381989
975893371
601943501
355752234
792584474
417540300
636456977
472663491
895909873
247993860
645949671
617560381
737019750
185489119
985534679
883975599
603394619
466358220
173600103
898187698
618843536
200902471
453177188
464899948
859625126
919452700
337751813
558027375
427146625
686765105
289982914
507984628
513068107
495434352
262109192
617053134
931499341
778876084
504755660
335221489
817234695
902125670
244812660
790977985
817022755
405391341
522336724
888023963
269531595
727398431
351646875
461233296
560683295
207924680
749919086
526058289
684383038
599267705
116689130
651703725
587853092
650330219
764835463
960662162
722398627
375142744
985171269
434500454
292322128
216559414
604166072
405472574
507583727
374335832
212663335
962858104
194050962
594255852
652002436
890060120
578420835
766083730
117273217
245434206
761682086
861435939
408087208
428074915
489940154
600669991
511205028
108808377
296749089
716563413
810895558
335237562
326771562
874586598
386156170
789151146
979523148
761850991
274595249
904682413
446190535
259532682
831036741
500789038
620283419
275779215
861961435
928093508
619992211
264606975
282034916
895530519
944369962
820746649
834937331
706430809
135754120
287453273
870422243
989802036
189310086
834726347
673285354
252574861
788094973
811154811
807096874
832065360
850054885
125330834
559684419
634482169
644625139
218779457
222495069
668362994
172503985
940022037
465089013
482712655
301407179
871783656
982610379
887608102
189999120
919918062
816233737
987713084
586480612
139913846
134033030
196466160
276739125
830809089
338978986
172499840
542550599
852074133
940595531
619770052
640901565
454445456
667516925
229718880
658079322
655487862
121526764
514969607
147042003
962713672
142065245
460514834
341798509
226963595
356168583
320605108
736863244
340086963
419150139
469371874
646913257
306918185
469221781
964084150
127365836
271499460
174732630
272523081
237523411
467680696
394993520
187858889
218207736
195299701
150229307
529306722
548349166
805873291
807048931
436305135
585608267
843365824
354708945
729035044
319424721
807164940
355436435
212524619
667296528
538541567
909343691
722385240
546143907
354790142
971994192
222403166
257743011
739025224
955214716
841657031
814005518
252963966
220263941
201918173
204549149
515284691
459080076
265055574
278845287
683793635
990716995
775093073
113610306
368875491
342808624
912390027
811561154
598845610
937542276
868573658
901700371
297408091
885029580
924371534
676247141
109662232
241766603
319973409
216576003
861922369
463152727
485248629
978198606
279527225
652152458
364691267
460011492
796823724
580208485
751594642
370811838
842618211
497642269
982144366
931142146
335053954
387242326
187281646
122316491
362684604
136066365
535586624
265885223
104246923
773745771
911804802
623479649
732565747
544009110
757345116
882806134
754392097
738612075
587526691
859499374
565966355
928981704
365507377
792165752
952936528
463145809
552278018
905842712
509753605
563428110
616646817
908923482
667913368
933734373
462576342
559657736
540015902
632602023
471832265
176960203
206523354
382021072
640289164
674226637
172591707
583764889
561880781
895554606
213763801
956245177
509805062
485760461
376266585
612880733
205252312
528344428
532359139
610732462
729871018
482271222
171384578
345939962
144065329
453226019
743220626
221487074
746549297
355156453
360530456
150929236
853998804
943084098
419373133
270114731
538246733
450792300
393346237
610278587
379251453
363268054
472901476
461478413
426119335
344101582
379287799
442567986
886958517
804376981
412803773
566045214
192861889
389502542
788104468
691768714
917809458
844827740
360254625
713797126
529085692
751456696
826699986
601736869
497817030
387084038
137170723
367896139
992063793
283681815
637520417
309561878
306686820
928135879
764936302
157988723
357162475
377554466
445315196
526716395
204347587
853966717
885824524
260050141
162560651
513118846
480010861
768716218
168879318
936753884
924075320
517060659
896273877
264534021
566337272
337379862
630988000
887153610
398300680
653843070
260541117
480276058
443299540
258338069
416663487
881649101
384345698
973833641
763750805
236904271
513283532
500790744
125281496
610780937
450523668
420990913
528470455
266854618
891517580
312893757
221687852
198611425
295442232
890767587
724126943
289081651
671410743
664435075
411211940
265699227
933571496
397166671
453917280
458176208
966531687
375991398
977968104
286024204
101823540
853321737
789171896
105141163
679223611
235124687
976380410
934688685
907407652
576228933
390435850
822890113
121278574
159100342
687416495
532336100
944474437
271626171
901617503
575389845
555608016
398139253
289133472
879685263
586357720
693321787
179048101
646650280
530108989
438522763
818863748
538149309
157976710
227742672
221644141
205405346
142198795
744104020
219143075
779245190
884369472
299557394
384896366
880727769
841359517
796135930
483561699
159957547
700224372
862768058
490552701
972308198
312841909
523884072
722523814
642246931
746685044
811184523
859191991
783857680
684552102
495418497
439478724
980015693
357990714
861712387
305214734
924841021
400391422
593413768
808427226
152333333
783753878
614931069
762165869
370884203
516608918
961696369
444707630
400264739
576903965
578761851
260205933
145431496
718184873
136510397
917343443
330016412
444514220
184240976
921767076
610555347
112820907
144408999
793391618
649764284
369177552
181513947
238081021
424068082
466297093
776448024
432106531
349153405
190802548
674073327
649709570
218745424
105762694
559255516
613700535
171431500
433179869
741855260
965486767
900085421
462184824
590188641
393655867
483408683
825493867
549031676
156108154
178118107
594025131
767081340
102692866
991205541
560741018
198741527
267244432
695564456
171821071
675705830
415306852
264974586
586019978
392450873
934782048
579353252
222467790
955247143
662821125
352920455
227819170
556740359
809692841
658296557
936429919
668378542
114350130
719787283
652459100
758840908
509404739
920207056
542941166
712296434
545711230
536655924
592362505
106007293
535131198
323324504
299984733
404720308
521809142
930207775
341070109
109211792
530031545
552948788
192967100
930859778
214933496
940103373
676778087
248416218
360810898
333837305
444296163
182078857
722229598
774433738
698764276
876719008
855166791
537154774
372496759
319373762
441548258
904345434
658014076
491843582
452589389
501580736
218946842
559288568
248604947
492348600
782335948
791742069
633502648
692786138
740221828
198930855
528318574
674622459
930921279
258445370
845009228
465197365
604518342
660562032
388255660
325116721
599749749
762722205
375710249
872316506
847365824
781188094
953026555
318019088
928641334
175964626
587120983
231766304
814803977
831931699
935085344
435237570
792079815
154385916
815823831
461319160
655217906
227393688
920816771
899979660
970501937
533274971
743291721
556561307
327278183
868060462
669243069
941809789
273769554
353381216
994626925
670559333
447683067
776091126
728165791
542507833
255464316
766393847
893530115
650466157
863836787
523115619
657748978
194517369
132190961
212552600
215170096
935256099
880821348
291265549
147073316
470485750
598239793
179645280
623416462
340398638
800153051
866231456
576221431
915957897
233448988
500494702
681362655
430441145
619672459
686818062
752005246
548887865
862493544
141167514
270632117
681152319
817859241
158344167
212814949
188416727
529271004
267387109
193368736
665339850
826968332
600745071
600692236
439910626
940908335
945856415
830800900
466490950
836853336
275103117
753219644
276805306
145782989
536310883
242201537
951306247
681485679
193347502
799162261
853621705
541007729
908606465
190038639
730830046
368090856
544062945
839438184
467868190
509658917
275319284
972440675
224397298
933041470
677107710
909016586
291653764
229334890
685576191
201844319
317575934
807498028
396408669
442766828
420083398
286943429
277441703
841230586
173424954
696659968
601949805
796011870
335581571
107515721
651078300
617284699
270354681
953612009
383432306
396373261
909040985
255835077
108879808
256892166
982513959
160928814
505164398
635523041
151804485
942750953
150010397
848562739
159087810
967668772
306038623
822396998
440053828
634662179
569443998
839045498
718449532
477155232
658657538
920201533
420154837
773782881
992003004
131302107
749122147
746941611
847168036
755201645
197082498
786327498
179156943
184706074
937183728
170939504
888283058
843204304
747802214
562534013
972841920
923414318
463274760
804634010
198961789
181409403
972510483
267380422
888507002
909710926
395710315
879146871
527029141
864627878
611005474
556932437
658732214
986252593
779064256
637597866
614298277
758167789
415937060
665648697
818459044
539943036
108599383
611805139
771059792
735417560
295040710
300219288
205132956
710275512
117980292
168733563
505296220
240470835
571838123
175275871
731631003
888078828
594986681
408074239
972274322
454838067
462819261
841004644
109745859
172327429
305203997
946310147
136388694
980047428
582927587
882197139
307326894
772192790
669619432
183434124
577948687
909171936
857351280
929551971
639510384
311689753
574100869
494477379
805909087
868341663
190089074
434633950
960591960
864227717
882771016
926997653
760820139
393533830
168352267
813755334
217695121
180148247
565275603
174076924
810525808
151808587
947537468
809716389
801362995
996746394
985228416
159407013
414602728
965942464
938561858
742353946
368330951
269243338
377182488
447273493
486275371
166773354
317144447
981821690
197829674
718491605
287175218
604920097
126605192
322966243
735588158
894879381
963329868
119675048
239735261
916801571
654868288
749137765
669138869
925637477
719231696
208900489
783827056
384409845
297427273
179733526
667011803
479214878
792372876
503028512
388336088
978874642
715219235
461438093
556834189
391925046
319844812
542336966
629045751
450091454
958556271
360902978
445077270
750337556
776499175
138511728
915909101
646232347
516473793
317041499
408303617
288491519
625705414
338662262
528802631
894720520
979324532
351326758
200371310
553588778
611462109
965308714
927223490
668796405
566787455
327010671
139841683
373499298
449717629
696581156
591920310
321374122
655512781
926257220
349094885
331744831
648769199
971283123
666544512
553794293
627551232
867477702
318648325
619367402
837354663
681374602
489431013
700502827
473198627
794710456
424860890
493888643
407133866
614893551
315031939
197644931
512247641
227120087
464678595
458692427
626349194
254537546
439065241
884891454
688924577
707464404
133280890
141235105
170783966
104714498
530496311
498901922
477674710
149948480
731586219
544115327
785067046
419959553
371383029
681938808
423447327
521522318
230267696
714358906
741317326
279649841
659678589
707293031
250033601
970174858
225875118
729622045
985052152
618085410
201408553
934925420
547627192
766562934
213216723
819414545
908097384
621108617
450517617
452846228
746701887
992433358
130947409
311970484
430399061
254618564
656539839
120928866
727329851
163836052
925463359
204583173
465325187
997869622
517640318
658372473
720011351
806254858
953101271
624640726
727825571
682708604
994572204
883879970
691266058
416602538
932451001
529328085
982519838
100000547
565290828
391273880
344978129
412340847
484859572
697129258
316126304
320573241
914092807
315013568
851753974
597090723
460710417
192379244
131203296
205167886
244406808
832276253
858619061
927591400
332424942
430239651
602641203
127498258
831340952
752805501
677581444
201271734
186007297
419479276
550898931
315488039
410090773
461576886
672066512
275310273
269357061
477838385
825312251
778352558
512350119
465782273
381725773
683115171
118479017
157174106
595654799
828226056
744711244
318258633
586855742
954401395
982412114
492515722
495410382
706691453
679231836
654052842
488562111
951007880
848507131
811847463
747107138
203792552
122971472
657818317
806751394
198266931
681904871
527222471
946687541
825828068
456071175
193747562
162112972
350296719
706832034
351764445
580451073
955883009
306950618
758705051
526624663
134874239
604328421
467281682
901556828
805366666
353703919
562067080
838667334
815954010
549444794
744661201
521496515
929520890
447936845
641419574
700118997
801154576
107192227
159847512
729214249
370123000
694570851
826154432
606964373
488170091
330446766
164621864
415006996
449007036
623379998
296345521
405645998
560669273
995068275
608026232
650557757
273681823
766750537
721593178
832117360
834883658
645061776
500839623
236977431
848623641
692509579
245746357
103670606
672500375
392882830
645263702
262657012
932532415
805055917
328115977
446796908
936692346
235790061
456007112
861018883
258944585
978947314
208721326
629172591
522679640
215855845
533646828
549904692
247468232
333226135
327146948
223707611
136891561
996867498
970039120
171983898
776712478
594676149
969836144
653442411
295654202
520412823
994162684
529713673
131582462
812671731
533792198
640500428
948839075
252585166
756178284
297201838
534212317
683886256
480910154
205395776
284582651
275557315
695618630
779028217
923586809
388070582
600992710
981443432
383288221
432876058
799454990
758471800
845208610
650706980
654762612
783922236
788347968
569506029
368175955
505581747
424226517
102383103
326802045
233502238
951258235
331187303
233336217
430597998
129647652
377606935
329710185
764633356
869831270
598304859
644309487
650458188
837670003
664592216
310279970
378259842
170635333
787051001
740176967
168400641
937784967
622697437
138862152
669170719
544977313
207211544
678583774
722556254
172992260
619519402
314596327
671634916
735550884
381473728
108639374
776821036
741763469
275182686
647632402
277216312
769631699
823456687
529870356
477264133
939337893
855751789
492363086
469302352
972011093
771444890
715697652
818963388
803776721
325120952
181202467
538876842
464718298
294970716
479158609
954941986
857153846
840332635
809437688
651554029
772333125
171825146
514738681
277021502
672020577
481307494
352201328
402280754
671638170
529552739
670829584
789839269
477946532
919074240
483591409
321198940
232188770
348229060
640826214
764089276
863861649
499583994
192555111
858182215
977580318
358814193
337772207
848547960
463019748
108832152
962636915
615936934
664697318
'''

csvdata2 = '''\
PaidVendorNumber
316126304
399384375
197082498
404509713
254537546
159100342
611805139
916730511
909780730
732565747
469371874
223264707
783922236
745509366
174732630
159957547
318648325
275557315
901617503
873299754
465353921
789171896
216576003
864227717
489729609
526716395
555608016
859191991
611805139
841359517
773745771
111367222
153501038
722398627
933041470
112820907
931499341
379251453
525797927
289081651
749137765
916730511
978198606
121922670
193368736
412340847
986252593
826968332
559657736
284582651
465782273
290728783
203792552
276047512
547063929
458176208
477155232
820616896
544480041
689945583
227393688
549904692
458176208
970174858
576228933
501003396
187281646
990129100
683886256
678696342
252574861
153501038
857153846
764633356
932451001
464899948
616256159
275557315
801692869
772333125
637597866
650706980
634482169
592591823
367522599
434633950
376266585
314596327
834883658
485633178
118479017
277021502
229718880
492363086
505581747
354790142
720585441
825493867
916730511
919918062
719787283
153501038
425283059
121526764
992003004
187281646
558027375
201408553
314596327
792249159
600992710
970729936
425608020
747802214
880875883
682479597
884891454
929520890
732565747
322966243
232188770
658296557
639510384
771310185
176960203
973833641
776712478
452589389
679223611
730413640
982610379
778876084
447273493
360530456
218207736
895530519
648769199
500713142
483621187
223250582
296749089
237523411
960662162
317144447
130947409
700224372
301407179
855166791
810525808
183434124
266854618
464718298
233336217
634482169
613947398
348229060
967668772
585608267
883975599
551970465
465353921
885029580
658372473
837670003
697129258
719787283
742353946
628914120
786327498
820616896
523884072
905842712
652152458
181513947
418173753
965486767
526058289
956245177
610278587
783922236
714367777
315031939
533274971
929520890
540015902
170635333
464728983
260020510
286943429
456007112
715697652
662821125
789151146
626052085
541923916
871783656
198741527
691768714
672322525
461233296
749184972
713797126
198611425
826154432
532561532
849544580
368175955
187131573
719787283
805768107
256892166
774299264
222802484
259674472
496952198
400495745
249404549
550935897
157988723
509404739
939337893
523989589
644309487
909586904
960662162
521809142
965308714
121922670
783827056
505164398
463145809
782365725
108639374
603394619
420083398
619519402
437936304
973636131
419150139
465089013
407479709
121922670
640500428
466358220
658657538
114350130
392450873
151804485
251988714
260020510
758893104
853621705
332424942
447665775
552278018
848562739
708418710
171821071
885824524
707293031
212524619
918142219
373471465
294970716
231930611
749184972
749184972
931499341
831340952
257270426
981068560
968011385
387242326
442567986
178467723
302550469
623379998
671410743
552278018
463152727
187131573
838667334
171431500
902501882
521496515
135754120
305203997
674622459
150035716
972841920
358814193
987408606
392450873
822333102
667913368
667461223
387084038
891517580
482712655
464718298
245966804
383432306
630988000
552017627
792372876
224404663
224404663
714358906
359619740
159957547
168733563
528580824
940908335
155428348
405895468
653843070
592934502
773782881
848547960
986252593
565966355
909480855
735588158
182861032
916801571
299984733
509404739
477667167
128704667
924824537
574640595
861018883
542336958
484730022
912490009
669619432
232188770
384896366
778876084
249404549
330016412
444707630
548349166
538876842
320573241
218745424
197829674
347003001
804029133
547627192
400264739
671638170
714636492
987408606
602941644
951007880
951007880
154385916
526716395
856389014
311689753
915586941
666544512
978947314
841230586
817234695
482271222
321374122
497642269
526109541
970174858
560741018
496004663
328115977
841004644
923414318
395710315
341798509
915586941
992063793
109745859
460514834
714358906
590188641
599267705
199413846
886388787
291797508
111367222
247468232
171983898
783922236
636456977
204549149
811154811
730413640
469371874
727329851
512247641
843993109
644309487
804376981
826092145
230267696
644490863
207211544
480276058
845208610
461319160
530612037
523989589
632602023
507583727
731631003
646650280
967668772
210765435
390435850
543418451
354790142
365372234
525797927
974130595
927579683
933472289
407467437
277441703
674622459
985228416
560669273
811561154
986252593
747171165
775093073
619519402
877765104
818963388
496004663
796823724
934925420
405895468
992562869
783010014
996867498
773186917
672287294
505296220
431980009
574640595
497642269
729871018
183434124
162562421
844141039
198266931
179733526
427556449
150010397
224397298
473198627
375710249
112980226
290728783
893530115
677581444
108639374
652002436
105141163
150035716
930207775
209594266
683886256
876719008
565275603
796823724
212524619
549031676
897476018
696659968
585608267
575389845
868758556
244844129
540015902
445315196
286943429
698794964
878405113
600992710
886535194
521496515
198296021
430239651
519766617
148341639
497642269
825493867
929551971
770690135
693321787
790977985
'''