####################################################################################
#                                                                                  #
# Copyright (c) 2003 Dr. Conan C. Albrecht <conan_albrechtATbyuDOTedu>             #
#                                                                                  #
# This file is part of Picalo.                                                     #
#                                                                                  #
# Picalo is free software; you can redistribute it and/or modify                   #
# it under the terms of the GNU General Public License as published by             #
# the Free Software Foundation; either version 2 of the License, or                # 
# (at your option) any later version.                                              #
#                                                                                  #
# Picalo is distributed in the hope that it will be useful,                        #
# but WITHOUT ANY WARRANTY; without even the implied warranty of                   #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                    #
# GNU General Public License for more details.                                     #
#                                                                                  #
# You should have received a copy of the GNU General Public License                #
# along with Foobar; if not, write to the Free Software                            #
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA        #
#                                                                                  #
####################################################################################
#
# This file is a Detectlet example.
#
# 02 NOV 2005  First version of the wizard
#
####################################################################################

DETECTLET_STANDARD = 1.0

from picalo import *
import random

wizard = '''
<wizard>
  <page>
    How many numbers do you want to create.  Since the numbers
    will match Benford's distribution *on average*, you need to generate
    at least 100 numbers for a good spread.  The more numbers you generate,
    the closer you'll get to the real distribution.
    here is more text after this one
    <parameter type="int" min="0" variable="number_of_numbers"/>
  </page>
  <page>
    How many digits should be in each number?  A value of 3 will generate 
    numbers between 100 and 999.  A value of 5 will generate numbers 
    between 10000 and 99999.  If you want to constrain the numbers
    to a specific range, use the "select" function on the resulting
    table.  However, note that constraining the numbers to a given
    range will likely skew the numbers away from Benford's distribution.
    
    More digits take exponentially longer to process.  For example, generating
    numbers more than five digits long may take a significant amount of time
    for your computer to process.
    <parameter type="choice" variable="number_of_digits">
      <option>1</option>
      <option>2</option>
      <option>3</option>
      <option>4</option>
      <option>5</option>
      <option>6</option>
      <option>7</option>
      <option>8</option>
    </parameter>
  </page>
</wizard>
'''

def run(number_of_numbers, number_of_digits):
  '''Generates a natural number that conforms to Benford's law of probabilities.
     Note that it would not make sense to return a number that *exactly* matches
     Benford's distribution -- the same number would be returned every time!
     
     Instead, this method generates numbers that *over time* match Benford's distribution.
     Individual returns may be right on or very far off from the expected values.
     But most of them will be close to Benford.
     
     The method only generates integers (no decimal part).  This is because decimal
     parts are not normally used in Benford's distribution.
     
     Repeated calls to this method will generate numbers that look like they are natural.
     
     This method is not to be used for fraud purposes -- only fraud detection purposes!
     
     @param number_of_digits: The number of digits to generate -- 2 is a number in the range 10-99, 4 is a number in the range 1000-9999
     @type  number_of_digits: int
     @return:                   A number that closely matches Benford's distribution.
     @rtype:                    int
  '''   
  # generate the digit distributions
  digit_distributions = []
  numdigits = int(number_of_digits)
  for position in range(0, numdigits):
    show_progress('Generating distribution for digit ' + str(position+1), float(position) / numdigits)
    prob = []
    start = (position == 0 and 1 or 0)
    for digit in range(start, 10):  # 1-9 or 0-9
      for j in range(0, int(round(Benfords.calc_benford(position, digit)*100, 2))):
        prob.append(digit)
    digit_distributions.append(prob)

  # generate a digit and return
  table = Table([('Number', number),])
  for i in range(number_of_numbers):
    show_progress('Creating Benfords Numbers...', float(i) / number_of_numbers)
    digits = [ str(random.choice(digit_distributions[position])) for position in range(numdigits) ]
    table.append([int(''.join(digits))])

  # return
  return table, RETURN_TEXT
  
  
RETURN_TEXT = '''<html><body>
<center><font size="+1">Create Benford's Numbers</font></center>
<p>
The results table contains numbers that match Benford's distribution. Please
use them to learn about fraud detection and <b>not</b> to commit fraud.
<p>
<i>Note that it would not make sense to return a number that *exactly* matches
Benford's distribution -- the same number would be returned every time!</i>
</body></html>
'''