####################################################################################
# 
# Created By: Matt Hillary
# Date: April 23, 2008
#
#
#
# Copyright (c) 2008 Matt Hillary <matt.hillaryATgmailDOTcom               
#                                                                                					  
####################################################################################
# UPDATES
#
####################################################################################
# STATUS: PRODUCTION
# 
# IDEAS/QUESTIONS/NOTES:
#
#
####################################################################################
DETECTLET_STANDARD = 1.0

from picalo import *

wizard = '''
<wizard>
  <page>
    Select the TABLE containing the COST OF GOODS SOLD and the SALE PRICE OF GOODS SOLD for each product:
    
    <parameter type="Table" variable="products_table"/>

  </page>
  <page>
    Select the COLUMN identifying the ID of each product:

    <parameter type="Column" table="products_table" variable="id_column"/>

	Select the COLUMN identifying the COST of each product:

    <parameter type="Column" table="products_table" variable="cost_column"/>
  </page>
  <page>
    Select the COLUMN identifying the SALE PRICE of each product?
    
    <parameter type="Column" table="products_table" variable="sale_price_column"/>
  </page>
</wizard>
'''

RESULTS_TEXT = '''The result table shows product with a comparibly excessive returns. 
The results are sorted by percent return--highest to lowest.
'''

def run(products_table, id_column, cost_column, sale_price_column):
  '''Kickbacks are illegal agreements between a buyer and a seller. These agreements most likely
  involve financial or other bribe-related agreements. Having excessive returns on a given 
  product is a symptom of kickbacks. To find excessive returns on a given product, this 
  detectlet analyzes the cost of goods sold versus the sale price of goods sold for a given product. 
  '''
  
  # run the analysis
  results = Table([
    ('ProductID', int),
    ('Cost', unicode),
    ('SalePrice', unicode),
    ('AmountReturn', unicode),
    ('PercentReturn', unicode),
  ])
  
  counter = 0

  #go through the table and calculate the amount of return for each product, calculate the percent return for that product, and sort the results table.
  for product in products_table:
    id = products_table[counter][id_column]
    cost = products_table[counter][cost_column]
    price = products_table[counter][sale_price_column]
    amountreturn = float(price) - float(cost)
    percentreturn = (float(price)/float(cost)) * 100
    rec = results.append()
    rec['ProductID'] = products_table[counter][id_column]
    rec['Cost'] = products_table[counter][cost_column]
    rec['SalePrice'] = products_table[counter][sale_price_column]
    rec['AmountReturn'] = amountreturn
    rec['PercentReturn'] = int(percentreturn)
    counter += 1
    show_progress('Analyzing...', float(counter) / len(id_column))
    Simple.sort(results, False, 'PercentReturn')

  return results, RESULTS_TEXT

  
def example_input():
  import StringIO  # to emulate a file for load_csv
  table = load_csv(StringIO.StringIO(csvdata))
  table.set_type('PartNumber', int)
  table.set_type('Name', unicode)
  table.set_type('Cost', unicode)
  table.set_type('SalePrice', unicode)
  return table

# This next part is not required, but it's easier to put the example data
# directly in this file so I don't have to worry about directories.
csvdata = '''\
PartNumber,Name,Cost,SalePrice
1234,Plate metal--carbon steel,54.00,70.20
1367,Plate metal--alloy steel--austenitic stainless,95.00,123.50
1448,Plate metal--alloy steel--ferritic stainless,105.00,136.50
1470,Plate metal--alloy steel--martensitic stainless,112.00,145.60
1501,Formed tube stock,46.00,92.00
1502,Formed square stock,49.00,107.80
1503,Sectional metal--I Beam,88.00,114.40
3425,Sectional metal--W Beam,145.00,188.50
4231,Welding wire,23.00,29.90
6780,Castings,14.00,18.20
6781,Fittings,14.00,18.20
7310,Bandsaw,445.00,578.50
7522,Cutting torch,167.00,217.10
9221,Chop saw,187.00,243.10
9483,Sectional metal--C channel,98.00,127.40
9671,Aluminum--aircraft quality,108.00,324.00
9763,Aluminum--standard machining and heat treatable,45.00,135.00
'''

