####################################################################################
#
# Name: Westin Hatch
# Email: <westinATbyuDOTedu>
# 
# 
####################################################################################
# UPDATES
# 18 April 2008   First edition of this detectlet
#
####################################################################################
# STATUS: PRODUCTION
#
#   IDEAS/QUESTIONS/NOTES:
#
#
####################################################################################
from picalo import *

# The wizard asks for two variables from two tables which are passed into the run
# method. Those variables are:
#
#    1) The table where the bid data is stored
#    2) The column that contains the bid ID numbers
#    3) The column that contains the contract ID numbers
#    4) The column that contains the total price amount of the bid

DETECTLET_STANDARD = 1.0

wizard = '''
<wizard>
  <page>
    Select the TABLE containing the bidding data:

    It should look similar to the example input data (see
    the previous page), and it should have columns for
    the contracts and amount.

    <parameter type="Table" variable="table"/>
  </page>
  <page>
    Select the COLUMN containing the bid number:
    
    (Example: BidID, BidNumber, bid_number)
    <parameter type="Column" table="table" variable="bidcol"/>
  </page>
  <page>
    Select the COLUMN containing the contract number: 
    
    This is the number
    that identifies the contract with which the bid was done.
    
    (Example:ContractID, ContractNumber, contract_number)
    <parameter type="Column" table="table" variable="contractcol"/>
  </page>
  <page>
    Select the COLUMN containing the bid price:  
    
    This the total price of the 
    entire bid.
    
    (Example:total_amount, bid_price)
    <parameter type="Column" table="table" variable="amountcol"/>
  </page>
</wizard>
'''


# This text will be displayed in a window of its own once the results
# are returned.
RESULTS_TEXT = '''\
The resulting table contains all the bids that had amounts that were 99.9% 
similar in price.

The 'PercentageIdentical' column lists the percentage similar 
and is in descending order with the most similar bid displayed first. The first 
column shows the lower bid amount followed by its price then the similar bid 
amount and its price. The percentage is obtained by dividing the first bid's 
price by the second bid's price.

Any bids that match up 100 percent are a pretty good indicator of some sort
of flaw in the system if not fraud.
'''


# This is the main function where the algorithm and logic for the program
# is embedded.
def run(table, bidcol, contractcol, amountcol):
  '''In the normal bid process, bidders are blind to the bid amounts put forth 
  by the other bidders for a particular contract. This is done so that the bid 
  process can result in truthful bids.
  
  Once all bids are received, they are put through a standards test to make sure 
  they measure up to the required strandards for the contract. All bids that pass 
  then move on to a financial-selection round in which the bid with the lowest 
  price is selected.
  
  Any bids that are extremely similar or exact in nature are quite suspicious 
  since the bid process and prices are so secretive. This detectlet will test 
  for any bids that are 99.9 percent similar. This means that when the lower 
  bid price is divided by the greater bid price, the resulting percentage is 
  99.9 percent or greater.
  '''
  # validate the data
  assert bidcol != contractcol != amountcol, 'The bid number, contract number, and amount columns must be different.  Please ensure you haven\'t selected the same column for two of these items.'
  
  # run the analysis
  # Make the skeleton table where the resulting similar bid amounts will be stored
  results = Table([
    ( 'BidNumber1', unicode ),
    ( 'BidAmount1', unicode ),
    ( 'BidNumber2', unicode ),
    ( 'BidAmount2', unicode ),
    ( 'PercentageIdentical', number),
  ])
  # Instantiate needed variables
  perc = 0.0
  counter = 0
  # Sort the bid table so that the records are in ascending order of bid amounts. This way
  # the program can logically search the bids rather than just compare every bid to all the
  # other bids.
  Simple.sort(table, True, amountcol)
  # Copy the table for a second for loop
  table1 = table[:]
  # Now each record is analyzed one at a time in a for loop
  for rec in table:
    counter = counter + 1
    # This shows the progress of the program to the user
    show_progress('Analyzing (' + str(counter) + ' of ' + str(len(table)) + ')...', float(counter) / len(table))
    # Now the record is compared to all the records in front of it or larger than itself until the records
    # exceed 1/10 of a percent
    for rec2 in table1:
      # No records should be compared against themselves or against records from other contracts
      if rec[bidcol] != rec2[bidcol] and rec[contractcol] != rec2[contractcol]:
        # Now the percentage is acquired dividing the record's amount by the amount of the record
        # against which it is being compared
        perc = rec[amountcol]/rec2[amountcol]
        # If the percentage is greater than 99.9 percent than the records are pretty similar and
        # are appended into the results table
        if perc >= 0.999:
          perc = perc * 100
          results.append(rec[bidcol], rec[amountcol], rec2[bidcol], rec2[amountcol], perc)
        # If they are under 99.9 percent, the records are too disimilar and the following comparison
        # records will be as well so the for loop is broken
        else:
          break
    # Delete the record off of the table so that it is not compared again and matches the record from
    # the original table
    del table1[0]
  # Delete the copy table
  del table1
  # Sort the results table by the most identical records and show the progress of it so the user
  # knows what is going on if it takes a while
  show_progress("Sorting results...", 0)
  Simple.sort(results, False, 'PercentageIdentical')
  clear_progress()
  # Throw back the resulting similar bid amounts
  return results, RESULTS_TEXT


# This is the method for example data from which an analysis can be run
# to show how the detectlet works
def example_input():
  import StringIO  # to emulate a file for load_csv
  table = load_csv(StringIO.StringIO(csvdata))
  table.set_type('BidNumber', int)
  table.set_type('ContractNumber', int)
  table.set_type('BidAmount', currency)
  return table



# This next part is not required, but it's easier to put the example data
# directly in this file so I don't have to worry about directories.
csvdata = '''\
BidNumber,ContractNumber,BidAmount
1004742,45,1173034.24
1023999,205,1147051.48
1036315,289,1043951.13
1053437,135,397170.2
1067041,196,203624.37
1077531,186,68382.42
1079921,62,12470.09
1087558,99,31550.69
1101387,87,220484.85
1105257,213,491899.81
1105410,201,203800.84
1112723,276,1056087.11
1153076,119,107292.76
1158794,13,1171301.61
1198106,85,138894.97
1241808,179,968929.42
1250893,80,1216747.08
1265181,164,823797.8
1267935,68,21943.43
1294159,220,1221184.07
1306840,32,938984.34
1315422,86,95177.6
1321538,29,111854.97
1329855,284,329058.14
1331494,210,720699.72
1342053,149,533539.9
1358921,92,1117969.16
1393672,30,353786.04
1396449,206,498394.1
1404386,231,443094.72
1446321,18,557472.46
1448191,10,999955.64
1448874,7,815792.97
1457799,153,908634.99
1467005,19,664747.17
1512726,218,1255711.82
1535260,30,461736.9
1549685,60,1028470.8
1549880,106,49340.66
1556228,276,508562.46
1562955,27,1316236.23
1589159,138,59373.47
1605280,139,1296294.67
1608880,167,1464425.26
1615013,50,1146134.29
1629562,183,732621.74
1647301,4,375491.42
1657304,126,1288219.39
1660174,290,413590.82
1660821,165,981038.18
1660935,178,1372781.94
1689334,24,1463289.01
1692081,55,194450.69
1700730,221,437207.77
1707784,233,692396.87
1715042,161,1038794.72
1720436,242,1289976.61
1728059,256,816476.63
1746606,299,356559.72
1765151,290,837125.39
1766521,29,1151107.99
1767540,179,1283095.93
1778879,199,1300773.82
1799555,114,152853.97
1807239,105,384181.15
1825276,63,179851.94
1825985,112,1496618.21
1827940,282,1006290.82
1839400,82,632297.4
1856824,25,388073.99
1869429,202,1217194.65
1875682,52,894605.71
1878121,96,602492.26
1882610,165,444302.51
1887556,58,985806.12
1897546,204,1495139.04
1911278,154,1172573.72
1915960,1,553695.12
1917245,1,872073.67
1922810,25,465155.34
1935382,239,672507.53
1941094,258,676477.93
1942813,78,1355712.97
1950932,240,1340256.96
1963284,173,1497174.93
1963752,267,548890.84
1965167,237,986307.16
1969100,286,983913.31
1989343,225,1288745.51
1997029,251,897399.21
1998741,225,463786.02
2008962,40,202029.54
2012154,299,979667.66
2014739,152,147912.28
2020364,29,1069674.42
2022601,102,882550.76
2025349,263,700751.74
2027833,256,575896.77
2036079,153,1170875.06
2036666,239,1313455.43
2055295,17,69786.42
2058726,187,905159.38
2061388,189,497227.71
2062073,184,804765.54
2065846,225,135819.74
2068520,160,904082.47
2078382,174,651529.22
2086640,202,1405120.83
2087844,108,494797.55
2094232,29,954895.66
2100058,47,814090.32
2100331,110,1413410.29
2118191,169,318465.21
2121397,49,305592.68
2126913,172,1247542.26
2134108,221,827881.15
2134331,141,561545.65
2136051,115,471601.25
2149674,190,800956.85
2152779,31,1418866.27
2153404,109,746658.71
2153993,2,1266203.34
2155465,175,533605.42
2156893,32,598467.95
2168014,29,289827.66
2187791,99,262692.83
2209542,175,746694.42
2210541,100,20831.58
2213396,94,101073.76
2214646,290,1248898.53
2235588,277,687270.58
2241487,136,68721.15
2263519,185,1472724.76
2285119,27,762468.32
2300602,11,1166413.51
2307069,244,356108.73
2308144,109,1090158.23
2321072,275,817777.69
2324921,50,1181563.7
2338228,49,433344.67
2344284,14,540868.12
2344338,132,1102238.71
2352788,214,703465.64
2356744,42,1339508.92
2364764,291,788807.23
2373369,15,687332.07
2389952,166,1354808.02
2414765,50,30799.6
2416287,94,846443.19
2428078,150,438237.72
2431172,249,730426.45
2450661,269,875393.19
2465053,61,309503.78
2479885,182,997841.25
2482346,186,1286696.25
2486449,26,1423110.44
2489488,217,338202.91
2494150,121,603170.33
2499697,252,1440014.38
2502850,127,272574.41
2505320,222,1005777.42
2527335,188,814830.63
2535697,4,876270.12
2540026,275,90388.85
2544689,202,256315.5
2546371,148,622901.8
2551015,191,1371330.85
2561520,52,1436964.77
2579862,176,735744.17
2581566,234,1176562.1
2582833,155,1414493.04
2589717,128,1280584.65
2601289,47,1051134.02
2601966,85,1163287.94
2605573,209,1196705.21
2659416,205,332845.73
2662723,279,665239.11
2667048,245,260052.68
2668929,74,310557.98
2675771,118,151447.87
2732934,187,750362.03
2739498,50,973242.6
2753253,277,781460.81
2775887,226,1435228.14
2780619,189,251374.84
2815286,6,996061.84
2816211,268,1225415.93
2837950,75,1339143.98
2840207,178,399426.72
2841449,27,963174.12
2863867,135,622612.53
2873935,43,771300.46
2879069,38,965027.12
2903735,267,588274.33
2904824,129,1462414.77
2905610,27,28921.76
2925215,67,821192.09
2949864,273,545474
2954466,18,1388456.26
2961317,182,1035328.94
2963285,128,91171.05
2984508,289,1092013.27
2985018,227,584310.24
2985974,245,1417604.8
2988411,227,639575.79
2995864,8,649348.92
2999296,160,553423.89
3029505,88,382449.24
3041886,101,1406127.19
3046273,59,695494.89
3049681,164,321985.33
3052864,241,520069.25
3053120,259,770713.11
3053475,253,1434832.99
3059101,228,545283.59
3073412,163,995247.31
3096745,51,630697.9
3114955,254,277240.7
3119263,73,1065603.67
3121343,271,1223471.61
3173152,22,1336522.23
3182091,283,1303624.76
3211879,288,1412577.16
3215934,284,769802.41
3228051,291,996829.61
3246002,225,86994.76
3258832,173,576957.51
3274887,189,29041.29
3278824,100,1469623.05
3288462,257,190747.69
3294961,200,1150115.46
3298285,166,582681.55
3319032,245,627960.11
3333951,136,600205.14
3334010,76,1401184.39
3337397,54,659227.24
3342314,29,618244.26
3345042,162,112229.79
3348955,106,466685.47
3352155,138,475786.11
3359476,39,243642.07
3361603,219,165351.87
3361618,180,510300.18
3364640,57,985748.29
3376861,258,956706.42
3379128,119,74883.48
3386526,180,354514.5
3395195,266,992046.97
3401320,40,624223.43
3401666,5,331294.26
3412129,63,1381439.45
3432157,130,49278.99
3450210,180,273092.42
3452790,16,467379.74
3491001,27,1102287.13
3493247,177,1368591.03
3499318,63,1154895.36
3500793,125,439279.84
3510803,269,1005226.32
3512575,226,1070531.92
3514310,131,592258.49
3524834,76,303003.45
3524946,264,198306.99
3529425,140,33623.43
3530235,263,1227750.22
3531086,36,395272.71
3539307,65,1088099.16
3541802,2,926747.5
3553463,137,699579.14
3557903,136,500298.4
3569848,161,937424.28
3596854,5,876479.44
3604366,287,1030848.17
3605003,256,1034470.04
3628605,233,375618.94
3629739,49,1182523.75
3656365,224,523779.54
3658404,12,455076.31
3689525,15,829890.23
3690708,119,960758.89
3715512,169,229131.7
3725254,166,958240.52
3733098,243,179568.1
3741056,13,520672.77
3757778,67,833292.26
3763030,78,1094741.15
3765000,20,1427038.27
3768571,253,985348.54
3772962,116,869906.71
3780401,157,1091162.54
3792141,8,1376560.77
3806164,3,1160221.56
3808698,10,511122
3810790,8,1050274.62
3819008,65,1288490.83
3839937,30,1250091.58
3848914,183,50430.32
3849851,119,1191590.24
3851025,147,891994.86
3856508,259,1495756.61
3859161,74,797546.91
3864306,173,876405.73
3865883,246,318465.21
3882110,32,1426099.81
3882801,221,718082.28
3884273,11,572503.93
3936637,18,845747.91
3948646,91,1335271.1
3962461,156,1215072.48
3982985,163,772674.16
3983719,51,455430.34
3999538,139,836949.58
4004573,4,1066755.28
4028253,130,144339.05
4028631,16,557192.37
4030020,232,186155.39
4035930,53,236879.96
4039903,272,5726.84
4059740,228,1171444.25
4064660,206,244373.75
4066017,132,1162655.75
4066501,259,96960.01
4080202,155,1469670.72
4095994,115,51089.25
4100984,66,520140.98
4116113,291,775516.73
4117160,178,1310718.44
4125559,175,1202425.01
4154113,291,1140203.54
4166751,184,1000433.26
4167264,85,609420.06
4169364,246,850966.85
4171211,288,239125.47
4180397,70,1488149.69
4186720,189,890979.97
4189450,253,1435902.07
4197062,116,900350.39
4205871,120,429788.6
4208545,95,1414550.79
4214081,283,730681.72
4214709,195,61365.48
4231107,167,1272499.46
4243475,182,646689.8
4259244,146,1327851.25
4262330,243,437860.83
4265518,288,1222015.63
4290520,49,868673.53
4296622,102,989354.89
4298249,72,1325414.57
4301398,35,1244027.92
4316598,167,725036.6
4325475,60,1104775.63
4330186,218,639876.53
4343997,69,868809.61
4348573,59,774777.11
4350980,169,1044072.83
4356203,164,1488562.59
4371810,152,172090.95
4377399,46,393731.31
4400212,63,1447630.23
4412714,247,1127218.06
4415070,184,1141433.12
4424244,101,1125373.51
4427614,60,933472.26
4433454,200,549675.21
4433498,70,1259706.9
4451467,293,66100.52
4452905,42,1387184.37
4453028,286,1382551.82
4456688,53,806653.78
4463244,278,627363.65
4465194,261,40749.96
4481869,149,1331946.62
4489679,274,1001275.95
4494895,221,61513.31
4504228,264,600004.83
4515227,283,656551.46
4526727,96,477068.86
4532982,258,394858.28
4537668,266,718117.28
4542089,59,1304606.5
4556504,199,110765.04
4560357,4,843701.49
4577694,246,1266844.78
4586118,112,729758.73
4588401,106,1181019.8
4600958,170,764925.34
4615583,227,706799.29
4630452,19,340299.03
4640279,124,231867.78
4643099,202,278835.41
4680905,203,1122493.56
4688636,235,943384.07
4697908,36,907807.4
4700969,25,515386.36
4709731,287,587772.01
4719344,148,674084.5
4723980,286,362089.66
4746220,133,41891.2
4761979,162,1287939.13
4763696,13,993576.17
4765893,105,1282432.34
4795351,105,1310382.01
4797468,149,1263576.29
4800166,278,1156350.7
4802965,265,339787.65
4807687,279,1196824.9
4815796,71,642313.73
4830281,58,1117514.78
4858834,2,1396616.23
4860779,65,1361609.67
4875042,268,1423671.71
4875864,77,642653.28
4882268,233,476236.03
4888838,213,377710.62
4901843,43,1140973.14
4917882,250,1361298.91
4933503,152,596353.71
4961939,121,575136.8
4973691,42,961771.35
4983036,93,290401.9
5001472,170,1226762.25
5013340,156,1169622.06
5022928,283,788360.86
5031488,79,607048.71
5035283,124,727717.59
5035440,127,590302.19
5040443,39,1009253.28
5049330,296,181385.37
5059352,136,293325.65
5088749,230,609622.75
5091757,146,127527.57
5097865,132,1242079.7
5101807,297,934624.62
5104732,151,1253815.47
5113822,162,1361676.32
5119014,153,864490.91
5124017,193,1121747.29
5127131,204,1020858.23
5140545,74,910425.17
5144120,228,1433897.28
5148631,207,974830.49
5153747,57,856783.5
5157635,39,1313684.34
5160798,257,910600.64
5166714,296,323711.61
5181352,127,154160.74
5187427,55,666634.97
5196005,157,135603.86
5197255,155,925489.35
5210932,10,1018126.3
5231175,14,476386.26
5236186,67,454117.63
5241310,165,989156.28
5254424,108,443845.82
5268627,165,1283970.27
5270304,130,1253664.9
5283320,80,69678.3
5302986,87,756399.69
5305016,162,1446564.61
5315974,20,614135.47
5328031,246,1175056.69
5347102,106,1322447.1
5378187,63,133919.86
5381247,81,1309515.04
5405383,76,819634.94
5405469,17,642506.91
5420928,279,107005.59
5450459,22,305154.78
5455432,188,1178489.57
5466895,101,746210.3
5467706,184,511261.2
5467989,195,486148.96
5476359,231,663870.8
5493320,253,1132752.93
5494915,72,789493.13
5499439,226,295820.33
5502134,212,191662.68
5502855,268,1218325.66
5515828,207,755523.76
5519116,283,58881
5526497,139,1252938.49
5529925,138,1323163.7
5535628,187,178974.01
5541165,160,744109.16
5547639,72,583226.45
5554058,221,509158.24
5554948,254,1066527.97
5580901,78,1473595.39
5598537,71,679407.32
5611626,45,742649.37
5617254,245,386142.35
5626868,266,215883.35
5644696,15,677433.08
5650965,123,650085.11
5655313,239,1096563.58
5662337,100,1175232.04
5667863,224,1037464.85
5678767,141,802783.61
5681464,288,274897.54
5692960,292,724521.41
5696938,87,1037765.94
5705313,53,428589.45
5706310,90,602356.07
5713359,154,1487049.71
5729267,152,1428537.16
5731486,109,190428.91
5732464,57,490799.73
5738899,13,138638.04
5746401,219,408270.66
5753255,138,579135.02
5766650,297,1424480.41
5770483,133,669884.38
5773937,74,1070134.82
5781590,243,1102032.28
5783524,199,387013.98
5788428,103,690349.55
5789118,193,917816.31
5790537,64,516357.18
5791208,18,247294.49
5792306,22,419263.64
5804311,213,682147.94
5815734,215,1321205.89
5824806,240,1072713.65
5836048,200,505378.16
5844875,184,1051172.65
5852339,121,837843.21
5859257,198,1292362.28
5867525,48,361763.42
5881276,79,951972.76
5889021,233,1024927.1
5894840,64,659041.64
5896743,197,159508.57
5898312,131,339681.28
5899629,60,1013615.67
5903320,246,1454360.66
5919959,55,1380490.44
5922189,287,1134817.58
5933968,31,589299.67
5940096,145,1032766.63
5943286,156,1330225.33
5945471,188,86376.06
5953296,87,670100.77
5954458,18,615614.53
5960489,142,1409330.13
5960712,7,341785.2
5961268,247,570712.24
5963919,54,35791.15
5979167,18,1325375.13
6028268,257,1286359.64
6032894,41,503705.23
6044264,3,975234.33
6044494,61,792867.2
6047250,9,1122593.03
6061309,276,1314928.38
6078835,248,1495198.67
6098754,92,1486767.68
6101914,109,732507.17
6103046,38,34796.59
6115235,166,1487628.02
6119341,104,302783.34
6123921,18,899307.36
6136691,228,904082.62
6149381,188,788006.92
6177587,253,819974.32
6179203,115,1202914.26
6182835,240,1348914.38
6185606,277,641678.44
6189063,14,1171079.44
6196139,120,441025.29
6206277,266,831943.33
6213751,2,76935.65
6214350,84,709169.28
6222800,230,1240887.52
6236673,152,532736.07
6247205,197,445178.06
6259161,282,1495167.71
6260569,70,380935.59
6265983,189,997860.74
6286527,19,903388.22
6289942,16,1282111.63
6294530,103,1147192.22
6317159,15,1174049.7
6337434,221,83902.4
6350474,250,1125110.91
6353455,164,172588.83
6359926,85,1060916.45
6365737,188,209297.05
6372426,273,1438104.03
6386858,172,1365080.46
6388425,19,1168746.31
6390692,73,116446.12
6393998,104,139429.28
6414666,18,1277140.28
6430000,283,1498577.48
6431680,9,1171660.81
6434613,86,1070037.64
6436765,202,515352.35
6442126,115,144020.13
6444882,248,929100.06
6462558,252,846217.07
6463663,228,1490252.72
6480857,108,1004778.43
6490889,64,359628.18
6497247,28,640434.16
6515759,63,1207050.59
6528276,225,1125105.38
6534741,102,1255282.3
6539953,90,1160650.98
6547317,84,194928.06
6547499,59,1147231.12
6551154,201,864166.95
6554020,57,336935.16
6558161,241,329363.77
6571537,66,1277598.88
6582795,189,755531.58
6587116,248,852048.27
6615335,235,1402920.95
6620089,187,858322.85
6621398,299,491758.49
6642262,45,1444796.11
6642739,43,563987.72
6646674,279,1016758.25
6647996,145,859924.29
6667979,258,662763.96
6671083,104,253303.74
6678568,54,843388.73
6679392,197,625882.51
6691058,115,904677.51
6696116,236,1405368.84
6698003,141,84320.29
6703836,87,1314087.61
6704474,106,488400.61
6726645,104,498332.64
6735556,198,462513.27
6737022,148,42514.01
6740295,39,459583
6744668,161,296728.46
6790077,111,514132.68
6813054,38,1119707.66
6815314,192,605011.01
6823027,66,1081509.34
6826548,267,886713.66
6843444,280,1402731.25
6844793,89,526701.22
6862303,181,394640.88
6878326,83,197817.75
6878851,204,311401.69
6880799,156,402286
6887368,31,710653.66
6900196,97,445750.56
6906802,244,471749.16
6907207,76,1279199.52
6909281,41,172692.31
6913294,219,1405726.62
6918902,104,809626.97
6923705,110,850208.27
6925930,77,675763.17
6930666,17,1187404.29
6944314,240,1461921.23
6971640,218,763114.55
6973516,287,1396615.24
6985778,252,1293068.93
6996771,8,1053448.12
7003926,226,831493.7
7022373,81,661425.07
7026436,216,954056.49
7026936,281,1249116.89
7028310,261,44010.72
7028608,226,1381658.31
7056217,185,278149.62
7059269,66,1204760.42
7060806,244,613048.04
7075206,169,956589.66
7077535,179,869671.51
7077851,39,528724.72
7080504,60,1026508.74
7100189,170,1495117.09
7102806,72,1484350
7105336,19,974000.89
7107120,120,1057289.46
7131657,166,299082.56
7142805,214,121022.02
7149213,288,1043510.28
7154879,176,833423.02
7158636,77,382770.19
7174447,206,1494740.68
7177270,262,1356169.3
7192265,62,1243783.77
7195604,179,989104.71
7196359,150,671983.48
7202385,103,1392804.87
7206340,193,1498663.83
7218068,131,171914.96
7234582,92,429399.22
7281891,219,1170677.21
7291949,109,1043671.37
7306168,252,1096057.44
7311715,74,376350.26
7319126,237,893902.59
7323687,13,1154129.66
7324341,181,1220596.5
7336452,11,1235870.49
7341725,205,1076029.91
7347414,63,1112160.79
7374274,232,770326.5
7396166,224,172759.34
7399073,60,1131166.48
7411590,194,818411.62
7412192,45,1324992.05
7418474,129,417263.06
7420526,195,1210029.74
7436429,93,786054.81
7447403,222,769071.13
7468235,231,1328522.78
7470665,148,701743.84
7471644,4,1277008.46
7484673,24,330661.6
7501893,90,57878.67
7503213,38,1364131.87
7504386,264,1224636.1
7507591,278,85659.18
7513581,117,432539.24
7536995,222,1412030.34
7537376,1,893387.28
7541630,131,1285241.14
7546371,278,302428.53
7548038,249,1485641.08
7552433,144,543726.27
7557487,131,413899.61
7558349,162,1073060.64
7558869,117,363834.63
7564451,167,1304692.55
7600064,47,606689.5
7602347,138,1011900.43
7622097,19,1365520.48
7627943,233,283828.13
7663818,87,330291.34
7682534,179,1261304.93
7687375,7,1187792.91
7687540,94,162348.2
7687950,187,439238.16
7691400,165,205008.77
7696547,207,1037956.89
7701345,73,237421.21
7711061,52,604617.45
7714189,292,435818.01
7719212,136,398161.78
7722469,275,877387.7
7753386,25,653750.08
7759675,124,1036401.29
7760656,32,1127842.6
7771666,113,887043.85
7780302,271,143818.81
7780851,100,9156.44
7810042,80,1206518.21
7818294,180,359199.44
7835998,178,889211.63
7838135,213,532194
7849251,74,1285309.21
7886745,106,967704.58
7911162,58,834636.13
7913396,222,50473.45
7921142,158,1458317.61
7925082,199,1040087.46
7928186,108,1481635.99
7929559,49,1321573.36
7948281,224,1339343.08
7952311,151,544624.27
7955594,11,1389372.07
7961947,172,980558.39
7962879,275,1395833.75
7990325,138,158040.31
7998367,251,127554.22
8001022,3,1069084.57
8014288,144,211330.87
8025010,287,831471.51
8042015,60,419880.02
8042113,122,1088966.58
8043654,261,321159.85
8050463,154,810690.43
8057788,269,1372091.68
8063793,48,1363224.09
8065505,79,718609.16
8071240,158,1042269.81
8072562,175,139308.83
8084894,95,627645.41
8097349,217,418538.19
8103436,201,719403.24
8121539,278,1297066.45
8126586,281,1350480.31
8133525,73,430156.89
8134872,103,797805.09
8150535,84,1441907.06
8152422,264,1243856.68
8152905,76,1039585.03
8170365,234,1189756.64
8217559,63,635623.41
8222399,227,1401136.83
8224700,95,828196.95
8224861,141,307250.06
8250900,261,382682.26
8261597,54,167862.38
8275367,120,48876.59
8276650,60,481969.89
8279061,256,329281.18
8280993,292,536660.23
8284341,12,1230787.77
8289625,137,1453820.7
8317753,231,887362.39
8317904,242,403699.7
8330649,138,738479.37
8330939,125,359298.11
8336313,164,934041.31
8361663,46,929719.73
8361706,11,467499.86
8365410,190,1298891.59
8375323,280,30643.19
8377620,239,669198.47
8382245,253,960059.7
8388121,21,313657.52
8389850,55,227323.06
8400495,219,1111387.74
8406432,134,999291.53
8412043,73,878742.03
8415263,280,783272.92
8416284,115,329924.99
8456336,280,247654.53
8462061,215,545713.27
8478798,54,31789.67
8487985,61,995895.83
8489973,130,684037.63
8506614,91,838688.56
8509738,113,1038133.3
8524973,235,666724.08
8540648,145,1005969.88
8542670,261,512807.78
8559340,102,1133160.42
8562778,82,1375038.91
8582603,101,24803.88
8596743,278,743053.32
8635795,121,759981.49
8641440,162,1341530.34
8653173,71,140064.86
8658659,202,14116.66
8684002,28,647222.17
8689589,22,868216.67
8696130,272,658456.46
8706094,245,325385.24
8728903,125,1141166.86
8737119,280,348902.35
8745770,230,1087919.67
8747489,153,1114199.15
8751413,280,1260942.56
8756150,278,948855.97
8757058,143,1403753.13
8757502,181,942010.62
8762045,270,459249
8764355,228,1019158.18
8778859,26,303796.57
8779599,160,178687.52
8792846,296,1052394.3
8799187,71,1077162.6
8826729,11,155975.94
8830759,96,1018669.51
8833082,6,617824.57
8834041,112,116734.5
8847732,265,670268.62
8848301,289,206940.33
8864440,97,821629.8
8888033,122,314707.49
8895959,26,303796.57
8907000,117,1133101.86
8911595,82,47247.33
8919426,49,1044976.74
8921392,33,88716.23
8930163,279,740942.99
8936886,249,551092.92
8940456,10,1298568.87
8944422,70,820701.94
8963611,69,1279031.34
8969128,286,539923.76
8969542,70,943153.61
8979385,128,1250285.76
8984599,153,122702.29
8985460,12,770300.69
8991593,171,764041.71
9016758,277,1328627.36
9020974,25,507620.5
9030704,298,783929.32
9034231,75,604190.1
9039322,209,1439756.49
9039988,211,1268250.16
9050302,62,501426.61
9059511,4,1272861.11
9064601,183,591568.67
9081113,113,1299126.16
9100643,225,503389.45
9112539,224,787997.19
9119921,138,1474119.39
9138052,234,45437.76
9153797,100,906128.35
9163444,159,681485.77
9164466,139,732025.41
9189200,101,1408827.41
9191353,75,366684.89
9195674,114,976757.42
9213539,120,387113.62
9214815,289,643768.02
9227229,224,19524.2
9229312,299,505826.04
9231090,3,555366.54
9237119,122,785715.68
9250026,175,1469214.88
9256263,233,940190.33
9257011,12,372830.31
9260582,114,1277979.34
9260609,66,816912.96
9264006,145,256150.57
9265079,93,530881.83
9313846,225,646761.85
9330189,245,260471
9347310,93,332801.11
9349325,281,1375251.77
9355258,59,562616.3
9355441,8,988708.02
9355673,133,1078830.77
9357869,272,757049.13
9362530,283,986280.2
9362640,230,418266.14
9366866,202,1046639.58
9370241,17,1159452.07
9378200,197,123412.55
9388415,177,1349761.66
9421575,196,10402.59
9439662,220,646468.54
9440730,86,265976.94
9441694,203,457220.76
9443182,6,862425.15
9444998,100,39159.76
9455645,265,136527.1
9459554,162,40628.5
9463204,226,812797.33
9468079,299,943750.78
9499033,150,338929.94
9511733,201,182639.88
9517247,70,444336.94
9547127,57,1208366.55
9565101,256,892871.13
9567245,153,1409920.23
9567350,132,539206.63
9572001,4,178825.35
9574380,285,1138652.21
9576761,44,482592.81
9577477,108,332214.88
9583856,85,807671.84
9594347,10,440492.01
9610662,278,1232792.19
9613338,32,1178632.32
9615501,279,1170423.58
9632922,201,889298.89
9635038,139,161405.72
9645559,100,928591.78
9649906,27,458756.54
9661863,73,1086393.19
9662823,247,1471661.29
9693494,54,513687.5
9701451,170,663064.94
9718052,32,59876.8
9739559,218,852275.87
9749143,145,162741.28
9756916,92,865519.69
9766768,103,588228.14
9767906,208,159559.71
9798892,167,1308316.46
9826979,155,729569.37
9831933,252,393919.63
9840169,51,1330241.89
9846003,218,358544.3
9856647,44,285275.11
9859826,148,493768.2
9870992,81,1262891.37
9882163,8,597286.71
9884088,296,775451.01
9893579,11,405217.06
9897904,151,385574.86
9904723,226,751601.34
9910348,45,526922.52
9930568,284,948421.93
9935762,228,43257.81
9935844,271,366113.44
9938817,168,1237502.14
9939807,83,1469246.96
9941125,30,1210414.9
9959563,136,1074506.25
9968050,234,666645.25
9979062,47,94071.86
9981303,174,457449.95
9984527,206,914710.9
9987776,254,423601.67
'''

