from picalo import *                            # import the Picalo libraries
import sys, re, random, os, os.path, urllib     # import commonly-used Python libraries

DETECTLET_STANDARD = 1.0

wizard = '''
<wizard>
  <page>
  Select the bidder TABLE:
    <parameter type="Table" variable="biddertable"/>
  </page>
  <page>
  Select the bid TABLE:
    <parameter type="Table" variable="bidtable"/>
  </page>
  <page>
    Select the COLUMN in the bid table with the project ID:
    <parameter type="Column" table="bidtable" variable="projectIDcol"/>
    Select the COLUMN in the bid table with the bidder ID:
    <parameter type="Column" table="bidtable" variable="bidderIDcol"/>
  </page>
  <page>
    Select the COLUMN in the bid table with the winner:
    <parameter type="Column" table="bidtable" variable="winnerIDcol"/>
  </page>

 </wizard>
'''

RESULTS_TEXT = '''\
    The displayed table contains the companies that always bid against each other
    and have a rotation of winners.
'''

def run(biddertable, bidtable, projectIDcol, bidderIDcol, winnerIDcol):
  '''Most organizations require multiple bids to increase 
  competition between suppliers. This keeps prices low and increases 
  quality.  Some companies may collude with each other to have a rotating winner
  bidder amoung them to fool the organization into thinking that they
  have received valid bids.  The colluding companies will discuss their bids
  with each other and have a low bidder picked out amoung them based on a 
  rotating cycle.
  
  This detectlet searches for companies that always bid against each other
  and having a rotating winner.
  '''
  
  # create the new table
  results = Table([
    ( 'Bidders', unicode),
    ( 'Projects', unicode),
    ( 'WinnerRotation', unicode),
  ])
    
  projects = ""
  projectArray = []
  collude = ""
  projectsList = []
  rotationOfWin = ""
  winnerList = []
  
  # search for projects and make an array of projects by bidder
  for bidder in biddertable:
    projects = ""
    for row in bidtable:
        if row[bidderIDcol] == bidder[0]:
            projects = projects + str(row[projectIDcol]) + '/'
    projectArray.append([bidder[0], projects])  
     
  # search for bidders that bid on all of the same projects   
  for i in range (0, len(projectArray)):
    z=0
    colludeList = []
    winnerList = []
    rotationOfWin = ""
    colludeList.append(projectArray[i][0])
    for j in range (0, len(projectArray)):
        if projectArray[i][1]==projectArray[j][1]:
            z +=1   
    
    #if two bidders bid on all of the same projects, find out what the projects were
    if z >1:
        rotation = 1
        collude = str(projectArray[i][0]) + "/"
        for j in range(0, len(projectArray)):
            if projectArray[i][1] == projectArray[j][1] and not i==j:
                collude += str(projectArray[j][0]) + "/"
        projectsList = []
        for row2 in bidtable:
            if row2[bidderIDcol] == projectArray[i][0]:
                projectsList.append(row2[projectIDcol])
        
        #create a list of winners for the projects
        for row2 in bidtable:
            if row2[projectIDcol] in projectsList:
                if row2[winnerIDcol] == "True":
                    winnerList.append(row2[bidderIDcol])
        #go through the list of winners to see if there is a rotation
        for x in range(1, len(winnerList)):
            if winnerList[x] == winnerList[0]:
                for y in range(0, x):
                    rotationOfWin += str(winnerList[y]) + "/"
                    if not winnerList[x+y]==winnerList[0+y]:
                        rotation=0
                 
        if rotation==1:
            rec = results.append()
            rec["Bidders"] = collude.rstrip('/')
            rec["Projects"] = str(projectArray[i][1]).rstrip('/')
            rec["WinnerRotation"] = rotationOfWin.rstrip('/')
        
                    
  #return
  return results, RESULTS_TEXT
  
def example_input():
  import StringIO  # to emulate a file for load_csv
  table = load_csv(StringIO.StringIO(csvdata))
  table.set_type('bid_id', int)
  table.set_type('project_id', int)
  table.set_type('vendor_id', int)
  table.set_type('winner', boolean)
  table2 = load_csv(StringIO.StringIO(csv2data))
  table2.set_type('bidder_id', int)
  table2.set_type('bidder_name', unicode)
  table2.set_type('bidder_address', unicode)
  table2.set_type('bidder_phone', unicode)
  table2.set_type('bidder_contact', unicode)
  return table, table2
# This next part is not required, but it's easier to put the example data
# directly in this file so I don't have to worry about directories.
csvdata = '''\
bid_id,project_id,vendor_id,winner
1,1,2,FALSE
2,1,3,TRUE
3,1,8,FALSE
4,1,4,FALSE
5,1,10,FALSE
6,1,13,FALSE
7,3,3,FALSE
8,3,9,FALSE
9,3,6,FALSE
10,3,13,FALSE
11,3,1,FALSE
12,3,14,TRUE
13,5,13,FALSE
14,5,14,FALSE
15,5,1,FALSE
18,5,13,FALSE
19,5,5,TRUE
20,5,15,FALSE
21,5,7,FALSE
22,8,2,TRUE
23,8,6,FALSE
24,8,3,FALSE
25,8,14,FALSE
26,8,10,FALSE
30,8,11,FALSE
31,8,8,FALSE
32,8,3,FALSE
33,8,6,FALSE
34,12,1,FALSE
35,12,4,FALSE
36,12,10,TRUE
37,12,9,FALSE
38,12,3,FALSE
39,12,8,FALSE
40,13,4,FALSE
41,13,16,TRUE
42,13,17,FALSE
43,13,18,FALSE
44,13,3,FALSE
47,13,8,FALSE
48,13,15,FALSE
49,14,8,TRUE
50,14,6,FALSE
51,14,9,FALSE
52,15,7,FALSE
53,15,5,TRUE
54,16,9,TRUE
55,16,8,FALSE
56,17,7,TRUE
57,17,12,FALSE
58,17,15,FALSE
59,18,6,FALSE
60,18,2,TRUE
61,18,9,FALSE
62,19,1,FALSE
66,19,14,FALSE
67,19,4,TRUE
68,20,10,TRUE
69,20,14,FALSE
70,20,1,FALSE
71,21,16,FALSE
72,21,17,FALSE
73,21,18,TRUE
74,23,13,FALSE
75,23,4,TRUE
76,23,1,FALSE
77,24,11,FALSE
78,24,7,TRUE
79,24,15,FALSE
80,25,12,FALSE
81,25,7,FALSE
82,25,15,TRUE
85,26,5,FALSE
88,26,11,FALSE
89,26,15,TRUE
90,27,16,FALSE
91,27,17,TRUE
92,27,18,FALSE
95,28,11,FALSE
96,28,1,FALSE
97,28,5,FALSE
98,28,15,TRUE
99,28,11,FALSE
100,28,8,FALSE
101,28,3,FALSE
102,28,12,FALSE
103,28,15,FALSE
104,28,13,FALSE
105,28,14,FALSE
106,28,10,FALSE
107,32,1,FALSE
108,32,4,FALSE
109,32,10,TRUE
110,32,9,FALSE
111,32,3,FALSE
112,32,8,FALSE
113,33,16,TRUE
114,33,17,FALSE
115,33,18,FALSE
116,34,8,TRUE
117,34,6,FALSE
118,34,9,FALSE
119,35,7,FALSE
120,35,5,TRUE
121,36,9,TRUE
122,36,8,FALSE
123,37,7,FALSE
124,37,12,FALSE
125,37,15,FALSE
126,37,16,FALSE
127,37,17,FALSE
128,37,18,TRUE
129,43,13,FALSE
130,43,4,TRUE
131,43,1,FALSE
132,44,11,FALSE
133,44,7,TRUE
134,44,15,FALSE
135,45,12,FALSE
136,45,7,FALSE
137,45,15,TRUE
138,46,5,FALSE
139,46,11,FALSE
140,46,15,TRUE
141,47,16,FALSE
142,47,17,TRUE
143,47,18,FALSE
'''
# This next part is not required, but it's easier to put the example data
# directly in this file so I don't have to worry about directories.
csv2data = '''\
bidder_id,bidder_name,bidder_address,bidder_phone,bidder_contact
1,ABC corp,123 Easy St,(555) 123-4567,John Doe
2,ABC Electronics,234 Beverly Drive,(801) 375-9468,Armand Hammer
3,ABC Kiddy World Pre School & Child Care Center,1026 E 460 S,(801) 373-7070,Christine Daae
4,ABC Great Beginnings,5890 Tree St,(801) 969-9236,Hapoel Tel Aviv
5,ABC Towing,490 Jones Dr,(801) 783-1587,Harley Quinn Smith
6,ABC Bartending Schools,943 Beer Way,(888) 262-5824,Keldorn Firecam
7,ABC Vacuum Warehouse,780 Access Road,(800) 285-8145,Minty Clinch
8,ABC Auto Paint Supply,1437 W Center St,(801) 225-7442,Oleude Jose Ribeiro
9,ABC Dental Michael van Leeuwen,6936 S 2475 E Apt 201,(801) 943-1612,Optimus Prime
10,ABC Fundrasing,9803 N 4680 W,(801) 756-0590,Urhines Kendall 
11,ABC Realty,907 Mover's Way,(435) 648-2729,Wrigley Fields
12,ABC Refinishing,393 E 500 N,(801) 768-2112,Zeppelin Wai Wong
13,ABC Spanish Translation,75 E 1750 N,(801) 802-0633,Vista Avalon
14,ABC Towing,2894 Broken Street,(801) 484-8537,Brent Sienna
15,ABC Waste Inc,1423 Jaguar Way,(801) 746-3355,American McGee
16,XYZ Learning,1437 W Center St,(801) 422-4738,Jack Hammer
17,XYZ Dentist,417 Edens Dawn Drive,(801) 713-4327,Keldorn Firecam
18,XYZ Faker, 438 Dell Drive,(801) 783-1587,Canaan Banana
'''

  