from picalo import *                            # import the Picalo libraries
import sys, re, random, os, os.path, urllib     # import commonly-used Python libraries

DETECTLET_STANDARD = 1.0

wizard = '''
<wizard>
  <page>
  Select the TABLE containing bid information:
    <parameter type="Table" variable="bidtable"/>
  </page>
  <page>
    Select the COLUMN in the bid table with the project ID:
    <parameter type="Column" table="bidtable" variable="projectIDcol"/>
    Select the COLUMN in the bid table with the security bank:
    <parameter type="Column" table="bidtable" variable="securityBankcol"/>
  </page>
  <page>
    Select the COLUMN in the bid table with the security instrument number:
    <parameter type="Column" table="bidtable" variable="securityNumbercol"/>
  </page>
 </wizard>
'''

RESULTS_TEXT = '''\
    The displayed table contains the rows where companies have incremental security
    instrument numbers.
'''

def run(bidtable, projectIDcol, securityBankcol, securityNumbercol):
  '''Most organizations require multiple bids to increase 
  competition between suppliers. This keeps prices low and increases 
  quality.  Companies will collude with each other to have a rotating winner
  bidder amoung them to fool the organization into thinking that they
  have received valid bids.  The colluding companies will discuss their bids
  with each other and have a low bidder picked out amoung them based on a 
  rotating cycle.  The company that is to win often has to do the work of preparing
  the bids for the other companies and paying the security instrument.  When
  a project has bids on it where the security instruments are from the same bank
  and in incremental order, fraud is likely.
  
  This detectlet searches for security instrument numbers that are incremental to each other
  within the same project.
  '''
  
  # create the new table
  results = Table([
    ( 'Project', unicode),
    ( 'SecurityBank', unicode),
    ( 'SecurityInstrumentNumber', int),
  ])
     
  # search for projects and make an array of projects by bidder
  for row in bidtable:
    for num in bidtable:
        if row[securityNumbercol]+1==num[securityNumbercol] and row[projectIDcol]==num[projectIDcol]:
            rec = results.append()
            rec["Project"] = row[projectIDcol]
            rec["SecurityBank"] = row[securityBankcol]
            rec["SecurityInstrumentNumber"] = row[securityNumbercol]
        if row[securityNumbercol]-1==num[securityNumbercol] and row[projectIDcol]==num[projectIDcol]:
            rec = results.append()
            rec["Project"] = row[projectIDcol]
            rec["SecurityBank"] = row[securityBankcol]
            rec["SecurityInstrumentNumber"] = row[securityNumbercol]
            
  #return
  return results, RESULTS_TEXT
  
def example_input():
    import StringIO  # to emulate a file for load_csv
    table = load_csv(StringIO.StringIO(biddata))
    table.set_type('bid_number', int)
    table.set_type('project_id', int)
    table.set_type('bidder_number', int)
    table.set_type('security_bank', unicode)
    table.set_type('security_instrument_number', int)
    return table

biddata = '''\
bid_number,project_id,bidder_number,security_bank,security_instrument_number
2100,10010,9,Zions Bank,276
2101,10010,13,Bank of America,359
2102,10011,8,JP Morgan Chase,317
2103,10011,10,Wells Fargo,315
2104,10011,16,Far West Bank,453
2105,10012,2,Affinity Bank,312
2106,10012,11,Affiinty Bank,313
2107,10013,30,World Savings Bank,259
2108,10013,7,Ocean Bank,250
2109,10013,20,American National Bank,447
2110,10013,27,Washington Mutual,203
2111,10013,1,Fidelity Bank,259
2112,10013,25,Bank of America,335
2113,10013,12,Bank of America,336
2114,10013,15,First National Bank,451
2115,10014,19,Commerce Bank,422
2116,10014,6,Wachovia Bank,388
2117,10014,24,JP Morgan Chase,206
2118,10014,29,Bank of America,315
2119,10015,26,Citibank,364
2120,10015,14,State Bank,271
2121,10015,22,Zions Bank,360
2122,10015,17,Key Bank,280
2123,10015,28,National City Bank,420
2124,10016,3,Utah Community Credit Union,493
2125,10016,23,First National Bank,250
2126,10016,4,Citizens Bank,291
2127,10016,18,American State Bank,305
2128,10017,21,Central Bank,300
2129,10017,5,Capital One,301
'''