####################################################################################
#                                                                                  
# Copyright (c) 2008 Travis Ringger <tringgerATgmailDOTcom>               
#                                                                                  
# This deteclet is part of the Bid Rigging wizards library.                     
# It does not require a license and is completely open source.                                    
#                                                                                  
####################################################################################
# UPDATES
#
# 05 April, 2008  First version of the wizard
#
####################################################################################
# STATUS:     
# 
# 
# IDEAS/QUESTIONS
#
#
####################################################################################

DETECTLET_STANDARD = 1.0

from picalo import *

wizard = '''

<wizard>
  <page> 
    Select the TABLE that contains information about
    the bids:
    
    (A project/contract will contain several bids.
    This table should contain one record for each
    bid.  It should contain a column for a Project Number/ID, 
    a Bid Number/ID, the Vendor ID, a cost estimate for that 
    bid, and a column that identifies the bid amount.)

   <parameter type="Table" variable="table"/>
  </page>
  <page>
    Select the COLUMN identifying the PROJECT/CONTRACT: 

    (Example: Contract_ID, Project_ID, Bid_Group)
    <parameter type="Column" table="table" variable="project_id"/>

    Select the COLUMN identifying the BID's ID NUMBER:
    (Examples: Bid_ID, Bid_Num, or Bid_Key)
    <parameter type="Column" table="table" variable="bid_id"/>
  </page>
  <page> 
    Select the COLUMN identifying the VENDOR:
    
    (Examples: Vendor_ID, Vendor, Vendor_Key, or Vendor_Foriegn_Key)
    <parameter type="Column" table="table" variable="vendor_id"/>

    Select the COLUMN containing the COST ESTIMATE of the bid? 

    (Example: estimate, cost_estimate, proposed_cost)
    <parameter type="Column" table="table" variable="cost"/>
  </page>
  <page>  
    Select the COLUMN identifying the bid amount?

    (Example: amount, amt, bid_amt)
    <parameter type="Column" table="table" variable="amt"/>
  </page>
  <page>  
    Enter the percentage (in decimal form) above the estimated cost would you like 
    to use as the cutoff point for an excessively high bid:
    
    (Example: 0.50, 0.60)
    <parameter type="float" variable="percentage" default="0.6"/>
  </page>

</wizard>
'''

RESULTS_TEXT = '''\
    The results contain the same columns as the input with the
    exception of the new percent_above_cost column.  This table displays 
    all of the results for which the bid amount is a certain percentage 
    above the cost estimate (the cutoff percentage is the number entered
    during the last step of the Wizard).  The vendor who sumbitted the bid
    is displayed on the same row as the percentage. 

    The results table is sorted by percentage_above_cost (high to low).  
    Therefore, the vendors whose bids lie at the top of the table are those
    who are likely to be engaged in Bid Rigging.  As always, however, further
    investigation is necessary to identify with certainty which of these 
    vendors, if any, are engaged in illegal practices. 
'''


def run(table, project_id, bid_id, vendor_id, cost, amt, percentage):
  '''One would expect a vendor to minimize the amount of its bid 
     so as not to bid excessively higher than its nearest competitor, yet bid just
     enough to win the contract.  It certainly seems illogical for a vendor to bid 
     well over its expected cost for completing the project.
	 
	 A common form of Bid Rigging, however, is Complementary Bidding.
	 According to the U.S. Department of Justice, "Complementary bidding (also known 
	 as "cover" or "courtesy" bidding) occurs when some competitors agree to submit 
	 bids that either are too high to be accepted or contain special terms that will 
	 not be acceptable to the buyer. Such bids are not intended to secure the buyer's 
	 acceptance, but are merely designed to give the appearance of genuine 
	 competitive bidding. Complementary bidding schemes are the most frequently 
	 occurring forms of bid rigging, and they defraud purchasers by creating the 
	 appearance of competition to conceal secretly inflated prices," 
	 (Price Fixing, Bid Rigging, and Market Allocation Schemes: What They Are and 
	 What to Look For, U.S. Dept. of Justice 
	 http://www.usdoj.gov/atr/public/guidelines/211578.htm).
	      
     The symptoms associated with this type of fraud include vendors who submit bids
	 that are much higher than published price lists, previous bids by the same firms, 
	 or engineering cost estimates.

     Note that not all high bids are proof of bid rigging.  Some may 
     be sincere estimate  mistakes on the part of the vendor, or even an attempt by the 
     vendor to submit a bid they realize will not be accepted, but do so in order to 
     remain on the purchaser's list of active vendors.  As always, further investigation
     is required to determine whether or not fraud has occurred. 
     
     This wizard analyzes vendor bids and compares them to the purchaser's cost estimate.  
	 A bid can be deemed excessive if it is a certain percentage above the estimate.  The
     percentage cut-off will be entered by the user, indicating the level at which a bid 
     is deemed excessively high in comparison to the purchaser's cost estimate.
     
     The wizard goes through the following process:
     
  '''
 
  # validate the data
  assert project_id != bid_id != vendor_id != cost != amt, 'The values you selected for Project ID, Bid ID, VendorID, Cost, or Amount are not unique. Please go back and select unique columns for these values from the table.'
  assert percentage < 1, 'The percentage must be less than one'

  # run the analysis
  results = Table([
    ( 'project_id',         unicode),
    ( 'bid_id',             unicode),
    ( 'vendor_id',          unicode),
    ( 'cost',               number ),
    ( 'amt',                number ),
    ( 'percent_above_cost', float  ),
  ])


#  projects = Grouping.stratify_by_value (table, project_id)
    
  for bid in table:
#    show_progress('Analyzing...', float(counter) / len(table))
    p = percentage
    p_above = bid[cost] / bid[amt]
    if p <= p_above:
      rec = results.append()
      rec['percent_above_cost'] = p_above * 100
      rec['project_id'] = bid[project_id]
      rec['bid_id'] = bid[bid_id]
      rec['vendor_id'] = bid[vendor_id]
      rec['cost'] = bid[cost]
      rec['amt'] = bid[amt]
  Simple.sort(results,False,"percent_above_cost")
  return results, RESULTS_TEXT

def example_input():
  import StringIO  # to emulate a file for load_csv
  table = load_csv(StringIO.StringIO(csvdata))
  table.set_type('Project', number)
  table.set_type('Bid', number)
  table.set_type('Vendor', number)
  table.set_type('Cost', number)
  table.set_type('Amount', number)
  return table



# this is the example data that will show if the user asks for it
csvdata = '''Project,Bid,Vendor,Cost,Amount
101,1001,1,105000,106550
101,1002,2,105000,108650
101,1003,3,105000,102250
101,1004,1,105000,139650
101,1005,4,105000,126000
103,1006,3,295000,314000
103,1007,1,295000,236000
103,1008,2,295000,292050
103,1009,4,295000,197650
103,1010,5,295000,324500
103,1011,6,295000,271400
103,1012,7,295000,274000
104,1013,4,30000,33300
104,1014,3,30000,33900
104,1015,2,30000,33500
104,1016,1,30000,32900
105,1017,2,120000,124000
105,1018,4,120000,124000
105,1019,7,120000,96000
105,1020,9,120000,118800
105,1021,1,120000,80400
107,1022,2,960325,1056357.5
107,1023,1,960325,883499
107,1024,4,960325,1112390
107,1025,5,960325,854689.25
107,1026,3,960325,768260
107,1027,6,960325,9217325
109,1028,7,978275,9226300
109,1029,8,978275,9235275
109,1030,9,978275,9244250
109,1031,3,978275,9253225
109,1032,2,978275,1088885.25
109,1033,1,978275,910450.75
109,1034,4,978275,1418498.75
110,1035,5,987250,993042.5
110,1036,6,987250,1004700
110,1037,6,987250,984700
110,1038,5,987250,789800
111,1039,3,996225,986262.75
111,1040,4,996225,667470.75
111,1041,1,996225,1015847.5
111,1042,2,996225,916527
111,1043,7,996225,995470
113,1044,8,1014175,1025734.25
113,1045,2,1014175,1016017.75
113,1046,3,1014175,1010553.75
113,1047,4,1014175,1018852.75
113,1048,8,1014175,1117010
113,1049,6,1014175,1077010
113,1050,12,1014175,811340
113,1051,3,1014175,1004033.25
115,1052,2,1032125,691523.75
115,1053,1,1032125,1035337.5
117,1054,3,1050075,966069
117,1055,2,1050075,1160090
117,1056,2,1050075,1065583.25
117,1057,1,1050075,1086584.75
121,1058,4,1085975,1074663.75
121,1059,5,1085975,1044346.75
121,1060,3,1085975,1003170
121,1061,6,1085975,1003170
125,1062,7,1121875,897500
126,1063,8,1130850,1119541.5
126,1064,9,1130850,957669.5
126,1065,3,1130850,1243935
127,1066,2,1139825,1048639
127,1067,1,1139825,1167790
127,1068,4,1139825,1014444.25
128,1069,5,1148800,1108000
128,1070,6,1148800,1075168
128,1071,6,1148800,1098144
128,1072,5,1148800,1165760
129,1073,3,1157775,1139840.75
129,1074,4,1157775,1189330
129,1075,1,1157775,1189330
129,1076,2,1157775,926220
130,1077,7,1166750,1055082.5
130,1078,8,1166750,781722.5
130,1079,2,1166750,1183425
131,1080,3,1175725,1081667
131,1081,4,1175725,1210870
131,1082,8,1175725,1105054.75
131,1083,6,1175725,1128569.25
131,1084,5,1175725,1204801.25
132,1085,4,1184700,1175651
132,1086,7,1184700,1221640
132,1087,3,1184700,1121640
132,1088,2,1184700,947760
132,1089,9,1184700,1172853
133,1090,10,1193675,799762.25
133,1091,2,1193675,1113042.5
133,1092,1,1193675,1198181
133,1093,4,1193675,1132410
136,1094,5,1220600,1086334
136,1095,3,1220600,2008900
136,1096,6,1220600,1224866
136,1097,7,1220600,1229278
137,1098,8,1229575,1222883.75
137,1099,9,1229575,1225334.75
137,1100,3,1229575,1225490
137,1101,7,1229575,1225490
137,1102,6,1229575,983660
137,1103,5,1229575,1217279.25
137,1104,4,1229575,823815.25
138,1105,6,1238550,1322405
138,1106,6,1238550,1139466
138,1107,5,1238550,1486260
138,1108,3,1238550,1112309.5
140,1109,4,1256500,1250000
140,1110,1,1256500,1304715
141,1111,2,1265475,1389986.75
141,1112,7,1265475,1264938.75
141,1113,8,1265475,1223081.75
141,1114,2,1265475,1508570
141,1115,3,1265475,1268570
141,1116,4,1265475,1262380
141,1117,8,1265475,1262820.25
141,1118,6,1265475,847868.25
142,1119,12,1274450,12701895
142,1120,3,1274450,1172494
142,1121,2,1274450,1229340
142,1122,1,1274450,1214639.5
142,1123,3,1274450,1240128.5
144,1124,2,1292400,1273980
144,1125,2,1292400,1218892
144,1126,1,1292400,1250880
144,1127,4,1292400,1250880
148,1128,5,1328300,1362640
148,1129,3,1328300,1315017
148,1130,6,1328300,889961
149,1131,7,1337275,1331002.5
149,1132,8,1337275,1330293
149,1133,9,1337275,1304730
149,1134,3,1337275,1330174.75
149,1135,2,1337275,1334375.25
151,1136,1,1355225,1331404.25
151,1137,3,1355225,1345076.25
151,1138,2,1355225,1302449.25
151,1139,1,1355225,1356270
152,1140,2,1364200,1337040
152,1141,5,1364200,1361360
152,1142,3,1364200,1350558
152,1143,4,1364200,914014
152,1144,1,1364200,1360620
154,1145,2,1382150,1371578
154,1146,7,1382150,1358580
154,1147,8,1382150,1334186.5
154,1148,2,1382150,1361829.5
154,1149,3,1382150,1304117.5
155,1150,4,1391125,1350196.25
155,1151,8,1391125,1369350
155,1152,6,1391125,1369350
155,1153,12,1391125,1112900
157,1154,3,1409075,1394984.25
157,1155,2,1409075,944080.25
157,1156,1,1409075,1449982.5
158,1157,3,1418050,1404606
158,1158,2,1418050,1401660
158,1159,4,1418050,1412064.5
158,1160,3,1418050,14111000
158,1161,8,1418050,14119975
'''
