from picalo import *                            # import the Picalo libraries
import sys, re, random, os, os.path, urllib     # import commonly-used Python libraries

DETECTLET_STANDARD = 1.0

wizard = '''
<wizard>
  <page>
    Select the bidder table:
    <parameter type="Table" variable="biddertable"/>
  </page>
 </wizard>
'''

RESULTS_TEXT = '''\
    The displayed table contains the IDs of the matching bidders and the information that they have in common.
'''

def run(biddertable):
  '''Most organizations require multiple bids to increase 
  competition between suppliers. This keeps prices low and increases 
  quality.  A common fraud is for bidders to set up dummy companies so that they can
  submit multiple bids or inflate the number of bids submitted.
  
  This detectlet searches for bidders that have similar information with other bidders
  (the same phone number, address, etc.)
  '''
  
  # create the new table
  results = Table([
    ( 'MatchingBidderID1', unicode),
    ( 'MatchingBidderID2', unicode),
    ( 'MatchingInformation', unicode),
  ])

  # search for matches
  for bid1 in biddertable:
    for bid2 in biddertable:
        for i in range(0, biddertable.column_count()):
            if bid1[i] == bid2[i]:
                if not bid1 == bid2 and bid1[0]<bid2[0]:
                    rec = results.append()
                    rec["MatchingBidderID1"] = bid1[0]
                    rec["MatchingInformation"] = bid1[i]
                    rec["MatchingBidderID2"] = bid2[0]
                    

  #return
  return results, RESULTS_TEXT
  
def example_input():
  import StringIO  # to emulate a file for load_csv
  table = load_csv(StringIO.StringIO(csvdata))
  table.set_type('bidder_id', int)
  table.set_type('bidder_name', unicode)
  table.set_type('bidder_address', unicode)
  table.set_type('bidder_phone', unicode)
  table.set_type('bidder_contact', unicode)
  return table
# This next part is not required, but it's easier to put the example data
# directly in this file so I don't have to worry about directories.
csvdata = '''\
bidder_id,bidder_name,bidder_address,bidder_phone,bidder_contact
1,ABC corp,123 Easy St,(555) 123-4567,John Doe
2,ABC Electronics,234 Beverly Drive,(801) 375-9468,Armand Hammer
3,ABC Kiddy World Pre School & Child Care Center,1026 E 460 S,(801) 373-7070,Christine Daae
4,ABC Great Beginnings,5890 Tree St,(801) 969-9236,Hapoel Tel Aviv
5,ABC Towing,490 Jones Dr,(801) 783-1587,Harley Quinn Smith
6,ABC Bartending Schools,943 Beer Way,(888) 262-5824,Keldorn Firecam
7,ABC Vacuum Warehouse,780 Access Road,(800) 285-8145,Minty Clinch
8,ABC Auto Paint Supply,1437 W Center St,(801) 225-7442,Oleude Jose Ribeiro
9,ABC Dental Michael van Leeuwen,6936 S 2475 E Apt 201,(801) 943-1612,Optimus Prime
10,ABC Fundrasing,9803 N 4680 W,(801) 756-0590,Urhines Kendall 
11,ABC Realty,907 Mover's Way,(435) 648-2729,Wrigley Fields
12,ABC Refinishing,393 E 500 N,(801) 768-2112,Zeppelin Wai Wong
13,ABC Spanish Translation,75 E 1750 N,(801) 802-0633,Vista Avalon
14,ABC Towing,2894 Broken Street,(801) 484-8537,Brent Sienna
15,ABC Waste Inc,1423 Jaguar Way,(801) 746-3355,American McGee
16,XYZ Learning,1437 W Center St,(801) 422-4738,Jack Hammer
17,XYZ Dentist,417 Edens Dawn Drive,(801) 713-4327,Keldorn Firecam
18,XYZ Faker, 438 Dell Drive,(801) 783-1587,Canaan Banana
'''



  