####################################################################################
# 
# Created By: Matt Hillary
# Date: April 14, 2008                            
#
# Copyright (c) 2008 Matt Hillary <matt.hillaryATgmailDOTcom               
# 
# This is a detectlet to detect a type of Check Tampering Fraud where a check processor has too many "Void"ed checks.
#                                                                                					  
# It requires a license and is not open source.                                    		       
#
####################################################################################
# UPDATES
#
####################################################################################
# STATUS: PRODUCTION
# 
# IDEAS/QUESTIONS/NOTES:
#
#
####################################################################################
DETECTLET_STANDARD = 1.0

from picalo import *

wizard = '''
<wizard>
  <page>
	Select the TABLE containing information on checks--check number, payment processor, check status:
		
    <parameter type="Table" variable="table"/>
  </page>
  <page>    
    Select the COLUMN identifying the names/ID numbers of the payment processors:
    
    <parameter type="Column" table="table" variable="paymentprocessor_column"/>

	Select the COLUMN identifying the status of checks:

    <parameter type="Column" table="table" variable="status_column"/>

   </page>
  <page>    
    Select the COLUMN identifying the check number:
    
    <parameter type="Column" table="table" variable="checknumber_column"/>
   </page>
 </wizard>
'''

RESULTS_TEXT = '''The displayed table shows a list of payment processors with his/her corresponding number of voided checks and voided check numbers.
'''


def run(table, paymentprocessor_column, status_column, checknumber_column):
  '''A possible fraud occurs when a payment processor is associated with too many voided checks. 
  
  A check can be voided for a variety of reasons. In one instance, a check is voided after making
  an e-check online for goods or services. A check is also voided after making an e-check payment
  over the phone. The check number, account number, and routing number are
  used to make the purchase, and, after the e-check is received, the payer voids the check. 
  
  In a company setting, a payment processor may void checks after making payments to vendors,
  but, sometimes, a payment processor may purchase goods for his/her own benefit, and void those
  checks as if they were a part of purchasing goods for the company. 
  
  This detectlet counts the number of voided checks per payment processor, sorts the list of all 
  check processors by the number of checks voided, and presents the payment processor, number of 
  voided checks, and a list of the voided checks.  
  '''
  
  # run the analysis
  results = Table([
    ( 'PaymentProcessor', unicode),
    ( 'NumberOfVoidedChecks', unicode),
	( 'ListOfVoidedCheckNumbers', unicode),
  ])
  
  counter = 0
  paymentProcessors = [] 
  concatProcessors = []
  checknumbers = []
  checknumberlist = ""
  
  for check in table:
    if check[4] == "Void":
      paymentProcessors.append(check[5])

  for processor in paymentProcessors:
    if concatProcessors.count(processor) == 1:
      print "already contains "+processor
    else:
      concatProcessors.append(processor)
      rec = results.append()
      rec['PaymentProcessor'] = processor
      rec['NumberOfVoidedChecks'] = paymentProcessors.count(processor)
      for check in table:
        if check[5] == processor and check[4] == "Void":
          checknumbers.append(check[0])
      for checknumber in checknumbers:
        checknumberlist = checknumberlist + str(checknumber) + ", "
      rec['ListOfVoidedCheckNumbers'] = checknumberlist[:-2]
      checknumbers = []
    checknumberlist = ""
    counter += 1
    show_progress('Analyzing...', float(counter) / len(paymentprocessor_column))
    Simple.sort(results, False, 'NumberOfVoidedChecks')
    
  return results, RESULTS_TEXT

  
def example_input():
  import StringIO  # to emulate a file for load_csv
  table = load_csv(StringIO.StringIO(csvdata))
  table.set_type('CheckNumber', int)
  table.set_type('Date', unicode)
  table.set_type('Payee', unicode)
  table.set_type('Amount', unicode)
  table.set_type('Status', unicode)
  table.set_type('PaymentProcessor', unicode)
  return table



#For Show Example button
csvdata = '''\
CheckNumber,Date,Payee,Amount,Status,PaymentProcessor
1234,28-Mar,SkyWest Airlines, $233.00 ,Paid,Chris
1235,28-Mar,Eastman Chemical Company, $144.00 ,Paid,Seth
1236,28-Mar,"Minnesota IMPLAN Group, inc", $108.00 ,Paid,Sam
1237,28-Mar,"Yum! Brands, Inc.", $374.00 ,Paid,Chris
1238,28-Mar,SPANX, $484.00 ,Void,Chris
1239,28-Mar,Miller Brewing, $21.00 ,Void,Seth
1240,29-Mar,Kurzweil Educational Systems, $5.00 ,Paid,Seth
1241,29-Mar,Cognizant Technology Solutions, $208.00 ,Paid,Seth
1242,29-Mar,Ingenuity Software, $469.00 ,Paid,Seth
1243,29-Mar,Bechtel Corporation, $397.00 ,Paid,Sam
1244,29-Mar,Morgan Stanley, $346.00 ,Paid,Sam
1245,30-Mar,CIGNA, $444.00 ,Paid,Seth
1246,30-Mar,Birdwell, $354.00 ,Paid,Seth
1247,30-Mar,Informix, $360.00 ,Paid,Seth
1248,30-Mar,General Motors Corporation, $263.00 ,Paid,Sam
1249,30-Mar,Rockwell Automation, $253.00 ,Paid,Calli
1250,30-Mar,McDonald's Corporation, $283.00 ,Paid,Seth
1251,30-Mar,"FreeWave Technologies, Inc.", $296.00 ,Paid,Seth
1252,30-Mar,Sunny Delight Beverages Co., $464.00 ,Paid,Seth
1253,31-Mar,Aspyr Media Inc., $200.00 ,Paid,Seth
1254,31-Mar,Red Hat, $375.00 ,Paid,Seth
1255,31-Mar,Altria Group (formerly Philip Morris Companies), $411.00 ,Paid,Seth
1256,31-Mar,Musco Lighting, $79.00 ,Paid,Seth
1257,31-Mar,Amgen, $59.00 ,Paid,Calli
1258,31-Mar,Go Daddy, $428.00 ,Paid,Calli
1259,31-Mar,"Staples, Inc.", $230.00 ,Paid,Calli
1260,31-Mar,The Dow Chemical Company, $458.00 ,Paid,Sam
1261,31-Mar,Marshall Pottery Inc., $166.00 ,Paid,Seth
1262,1-Apr,Valero Energy Corporation, $49.00 ,Paid,Calli
1263,1-Apr,Vectren, $348.00 ,Paid,Seth
1264,1-Apr,Procter & Gamble, $373.00 ,Paid,Sam
1265,1-Apr,H&R Block, $244.00 ,Paid,Calli
1266,1-Apr,Mattel, $210.00 ,Paid,Sam
1267,1-Apr,Yahoo!, $191.00 ,Void,Seth
1268,1-Apr,"Becton,Dickinson and Company", $379.00 ,Paid,Calli
1269,1-Apr,3M Company, $458.00 ,Paid,Seth
1270,1-Apr,Hastings Entertainment, $475.00 ,Paid,Seth
1271,1-Apr,Comodo, $319.00 ,Paid,Calli
1272,1-Apr,Arctic Cat, $348.00 ,Paid,Seth
1273,1-Apr,West Liberty Foods, $6.00 ,Paid,Calli
1274,1-Apr,DiC Entertainment, $295.00 ,Paid,Sam
1275,2-Apr,Zapata, $141.00 ,Paid,Seth
1276,2-Apr,Equifax, $248.00 ,Paid,Calli
1277,2-Apr,Texas Instruments, $169.00 ,Paid,Seth
1278,2-Apr,America Online, $376.00 ,Paid,Seth
1279,2-Apr,INVESTools, $286.00 ,Paid,Sam
1280,2-Apr,General Electric, $441.00 ,Paid,Seth
1281,2-Apr,Cerner Corporation, $35.00 ,Paid,Sam
1282,2-Apr,Columbia Pictures, $448.00 ,Paid,Seth
1283,2-Apr,Towers Perrin, $259.00 ,Paid,Chris
1284,2-Apr,Crazy Eddie, $324.00 ,Paid,Seth
1285,3-Apr,Infor, $72.00 ,Paid,Sam
1286,3-Apr,YRC Worldwide Inc., $246.00 ,Paid,Calli
1287,3-Apr,CVS Pharmacy, $402.00 ,Paid,Calli
1288,3-Apr,Arby's, $162.00 ,Paid,Calli
1289,3-Apr,Expeditors International, $147.00 ,Paid,Seth
1290,3-Apr,Arryx, $170.00 ,Paid,Seth
1291,3-Apr,Airimba Wireless, $261.00 ,Paid,Chris
1292,3-Apr,Russell Stovers, $158.00 ,Paid,Calli
1293,3-Apr,Laserfiche, $233.00 ,Paid,Chris
1294,3-Apr,Kimberly-Clark, $182.00 ,Paid,Seth
1295,4-Apr,Frontier Airlines, $195.00 ,Paid,Chris
1296,4-Apr,Six Flags Inc., $376.00 ,Paid,Chris
1297,4-Apr,PeopleSoft, $335.00 ,Paid,Seth
1298,4-Apr,Target Corporation, $452.00 ,Paid,Sam
1299,4-Apr,Verizon, $250.00 ,Paid,Seth
1300,4-Apr,Union Oil Company of California (Unocal), $190.00 ,Paid,Calli
1301,4-Apr,SBC Communications, $385.00 ,Paid,Calli
1302,4-Apr,Caterpillar Inc., $431.00 ,Paid,Seth
1303,4-Apr,XPLANE, $26.00 ,Paid,Calli
1304,5-Apr,State Street Corporation, $351.00 ,Void,Seth
1305,5-Apr,Lucent, $156.00 ,Paid,Calli
1306,5-Apr,Sprint Nextel Corporation, $319.00 ,Void,Calli
1307,5-Apr,Marsh & McLennan, $134.00 ,Paid,Calli
1308,5-Apr,World Wrestling Entertainment, $471.00 ,Paid,Seth
1309,5-Apr,American International Group, $83.00 ,Paid,Sam
1310,5-Apr,C.H. Robinson Worldwide, $220.00 ,Paid,Chris
1311,5-Apr,Kraft Foods, $305.00 ,Paid,Calli
1312,5-Apr,Nabisco, $422.00 ,Paid,Seth
1313,5-Apr,Federal National Mortgage Association, $108.00 ,Paid,Calli
1314,5-Apr,Red River Broadcasting, $354.00 ,Paid,Chris
1315,5-Apr,Diebold, $82.00 ,Paid,Calli
1316,6-Apr,Midway Games, $268.00 ,Paid,Chris
1317,6-Apr,Sunoco, $228.00 ,Paid,Sam
1318,6-Apr,Applebee's, $491.00 ,Void,Seth
1319,6-Apr,Halliburton, $280.00 ,Paid,Sam
1320,6-Apr,Citigroup, $9.00 ,Paid,Seth
1321,6-Apr,Vanguard Group, $300.00 ,Paid,Chris
1322,6-Apr,ExxonMobil, $18.00 ,Paid,Calli
1323,6-Apr,Lehman Brothers, $75.00 ,Paid,Chris
1324,6-Apr,Honeywell, $145.00 ,Paid,Seth
1325,6-Apr,"Kellogg, Brown and Root", $382.00 ,Paid,Calli
1326,7-Apr,Emerson Electric Company, $274.00 ,Paid,Seth
1327,7-Apr,Berkshire Hathaway, $159.00 ,Paid,Chris
1328,7-Apr,Union Pacific Railroad, $356.00 ,Paid,Seth
1329,7-Apr,Clear Channel Communications, $56.00 ,Paid,Calli
1330,7-Apr,Hot Topic, $290.00 ,Paid,Seth
1331,7-Apr,Wendy's, $455.00 ,Paid,Seth
1332,7-Apr,Control Data Corporation (CDC), $90.00 ,Paid,Calli
1333,8-Apr,Regis Corporation, $173.00 ,Paid,Seth
1334,8-Apr,United Airlines, $389.00 ,Paid,Sam
1335,8-Apr,Office Depot, $337.00 ,Paid,Seth
1336,8-Apr,Monsanto, $287.00 ,Paid,Calli
1337,8-Apr,Darden Restaurants, $46.00 ,Paid,Sam
1338,8-Apr,Sony Pictures Entertainment, $57.00 ,Paid,Chris
1339,8-Apr,Qwest, $302.00 ,Paid,Chris
1340,8-Apr,Louisiana Pacific, $36.00 ,Paid,Calli
1341,9-Apr,Time Warner (formerly AOL Time Warner), $453.00 ,Paid,Seth
1342,9-Apr,Crowley Maritime Corporation, $262.00 ,Paid,Calli
1343,9-Apr,Continental Airlines, $265.00 ,Paid,Calli
1344,9-Apr,AND1, $49.00 ,Paid,Chris
1345,9-Apr,Binney & Smith, $239.00 ,Paid,Seth
1346,9-Apr,TheStreet.com, $168.00 ,Paid,Calli
1347,9-Apr,Adobe Systems Inc., $127.00 ,Paid,Seth
1348,9-Apr,FedEx, $266.00 ,Paid,Calli
1349,9-Apr,Kmart Corporation, $482.00 ,Paid,Calli
1350,9-Apr,News Corporation, $76.00 ,Paid,Seth
1351,9-Apr,Anheuser-Busch, $300.00 ,Paid,Seth
1352,10-Apr,Penn Herb Company, $406.00 ,Paid,Seth
1353,10-Apr,Office Max, $492.00 ,Paid,Seth
1354,10-Apr,Qualcomm, $87.00 ,Paid,Chris
1355,10-Apr,Ford Motor Company, $323.00 ,Paid,Calli
1356,10-Apr,Whole Foods Market, $70.00 ,Paid,Calli
1357,10-Apr,eBay, $254.00 ,Paid,Seth
1358,10-Apr,Quincy Newspapers, $269.00 ,Paid,Seth
1359,10-Apr,Fox Film Corporation, $318.00 ,Paid,Sam
1360,10-Apr,Network Appliance, $407.00 ,Paid,Seth
1361,10-Apr,AnaSpec, $239.00 ,Paid,Calli
1362,10-Apr,Emcor Group, $38.00 ,Paid,Calli
1363,10-Apr,American Home Mortgage, $35.00 ,Paid,Seth
1364,11-Apr,Subway (restaurant), $74.00 ,Paid,Seth
1365,11-Apr,Hi-Point Firearms, $381.00 ,Paid,Sam
1366,11-Apr,Acme Markets, $294.00 ,Paid,Sam
1367,11-Apr,Zoomerang, $373.00 ,Paid,Calli
1368,11-Apr,"FileMaker Inc., formerly Claris Corp.", $474.00 ,Paid,Seth
1369,11-Apr,NCR Corporation, $112.00 ,Paid,Seth
1370,11-Apr,International Business Machines (IBM), $241.00 ,Paid,Calli
1371,11-Apr,Colt's Manufacturing Company, $87.00 ,Paid,Calli
1372,11-Apr,PACCAR, $220.00 ,Paid,Seth
1373,11-Apr,World Financial Group, $73.00 ,Paid,Seth
1374,11-Apr,Nike, $477.00 ,Paid,Calli
1375,11-Apr,Microsoft, $467.00 ,Paid,Seth
1376,11-Apr,International Paper, $175.00 ,Paid,Calli
1377,11-Apr,NetZero, $34.00 ,Paid,Seth
1378,11-Apr,Huntingdon Life Sciences, $246.00 ,Paid,Seth
1379,11-Apr,Ecolab, $115.00 ,Paid,Seth
1380,11-Apr,Safeco Corporation, $400.00 ,Paid,Chris
1381,11-Apr,Northwest Airlines, $283.00 ,Paid,Calli
1382,11-Apr,International Game Technology (IGT), $346.00 ,Paid,Calli
1383,11-Apr,Abbott Laboratories, $77.00 ,Paid,Chris
1384,12-Apr,J. P. Morgan Chase and Co., $403.00 ,Paid,Seth
1385,12-Apr,Midwest Communications, $7.00 ,Paid,Seth
1386,12-Apr,Corning Incorporated, $169.00 ,Paid,Calli
1387,12-Apr,CBS Corporation, $468.00 ,Paid,Calli
1388,12-Apr,"Merrill Lynch & Co., Inc.", $261.00 ,Paid,Sam
1389,12-Apr,Colt Defense, $40.00 ,Paid,Calli
1390,12-Apr,"Wells Fargo Bank, N.A.", $220.00 ,Paid,Calli
1391,12-Apr,Vocera Communications, $126.00 ,Paid,Chris
1392,12-Apr,Atari, $372.00 ,Paid,Seth
1393,12-Apr,Jones Soda Co., $44.00 ,Paid,Seth
1394,12-Apr,United Technologies, $200.00 ,Paid,Sam
1395,12-Apr,Doculabs, $467.00 ,Paid,Sam
1396,12-Apr,"ABX Air, Inc.", $415.00 ,Paid,Calli
1397,12-Apr,Amazon.com, $462.00 ,Paid,Seth
1398,12-Apr,Conseco, $179.00 ,Paid,Sam
1399,12-Apr,Local Matters, $295.00 ,Paid,Sam
1400,12-Apr,Avon Products, $156.00 ,Paid,Calli
1401,12-Apr,Hasbro, $132.00 ,Paid,Chris
1402,12-Apr,Avaya, $383.00 ,Paid,Sam
1403,12-Apr,"Liberty Corporation, The", $371.00 ,Paid,Chris
1404,12-Apr,AlliedSignal Inc., $362.00 ,Paid,Calli
1405,13-Apr,Martin Marietta Materials, $147.00 ,Paid,Seth
1406,13-Apr,Amphenol Corporation, $50.00 ,Paid,Sam
1407,13-Apr,KPMG, $323.00 ,Paid,Seth
1408,13-Apr,Hallmark Cards, $225.00 ,Paid,Chris
1409,13-Apr,Eastman Kodak, $443.00 ,Paid,Seth
1410,13-Apr,Salem Communications, $58.00 ,Paid,Calli
1411,13-Apr,Novellus Systems, $359.00 ,Paid,Calli
1412,13-Apr,Chrysler, $459.00 ,Paid,Seth
1413,13-Apr,JetBlue Airways, $85.00 ,Paid,Seth
1414,13-Apr,Northrop Grumman, $144.00 ,Paid,Calli
1415,13-Apr,Pan Am, $235.00 ,Paid,Calli
1416,13-Apr,Southwest Airlines, $444.00 ,Paid,Calli
1417,13-Apr,American Airlines, $371.00 ,Paid,Chris
1418,13-Apr,"Respironics, Inc.", $280.00 ,Paid,Calli
1419,14-Apr,Giant Food, $324.00 ,Paid,Seth
1420,14-Apr,Carls Jr, $369.00 ,Paid,Seth
1421,14-Apr,Kerr-McGee, $301.00 ,Paid,Chris
1422,14-Apr,Comcast, $288.00 ,Paid,Seth
1423,14-Apr,Xilinx, $174.00 ,Paid,Calli
1424,14-Apr,Starbucks, $139.00 ,Paid,Seth
1425,14-Apr,Abercrombie & Fitch, $366.00 ,Paid,Sam
1426,14-Apr,Russell Investment Group, $418.00 ,Paid,Chris
1427,14-Apr,Lucas Oil, $354.00 ,Paid,Sam
1428,14-Apr,Ace Hardware, $39.00 ,Paid,Chris
1429,14-Apr,Harley-Davidson, $218.00 ,Paid,Calli
1430,14-Apr,"Cisco Systems, Inc.", $60.00 ,Paid,Chris
1431,15-Apr,Bosch Brewing Company, $17.00 ,Paid,Seth
1432,15-Apr,El Paso Corp., $397.00 ,Paid,Seth
1433,15-Apr,Johnson & Johnson, $184.00 ,Paid,Seth
1434,15-Apr,Georgia Pacific, $277.00 ,Paid,Calli
1435,15-Apr,Westat, $456.00 ,Paid,Chris
1436,15-Apr,Universal Studios, $169.00 ,Paid,Calli
1437,15-Apr,NBC Universal, $331.00 ,Paid,Calli
1438,15-Apr,Intuit, $376.00 ,Paid,Seth
1439,15-Apr,Pizza Hut, $133.00 ,Paid,Seth
1440,15-Apr,Albertsons, $240.00 ,Paid,Calli
1441,15-Apr,Aaron Rents, $302.00 ,Paid,Sam
1442,15-Apr,Chem-Dry, $131.00 ,Paid,Seth
1443,15-Apr,Forum Communications, $421.00 ,Paid,Calli
1444,15-Apr,Sterling Commerce, $209.00 ,Paid,Calli
1445,16-Apr,Intel, $374.00 ,Paid,Sam
1446,16-Apr,ConocoPhillips, $90.00 ,Paid,Calli
1447,16-Apr,General Mills, $168.00 ,Paid,Seth
1448,16-Apr,Zappos.com, $451.00 ,Paid,Chris
1449,16-Apr,PepsiCo, $455.00 ,Paid,Calli
1450,16-Apr,Raytheon, $45.00 ,Paid,Sam
1451,16-Apr,The Coca-Cola Company, $445.00 ,Paid,Seth
1452,16-Apr,"PalmOne, Inc.", $119.00 ,Paid,Chris
1453,16-Apr,American Reprographics Company, $1.00 ,Paid,Seth
1454,16-Apr,Electronic Data Systems, $252.00 ,Paid,Calli
1455,16-Apr,Gartner, $62.00 ,Paid,Seth
1456,16-Apr,Cartoon Network Studios, $478.00 ,Paid,Chris
1457,16-Apr,Gentiva Health Services, $420.00 ,Paid,Seth
1458,16-Apr,AutoExtra.com, $361.00 ,Paid,Seth
1459,16-Apr,H J Heinz Company, $325.00 ,Paid,Calli
1460,16-Apr,Amtrak (National Railroad Passenger Corporation), $17.00 ,Paid,Chris
1461,17-Apr,American Broadcasting Company, $365.00 ,Paid,Chris
1462,17-Apr,Google, $109.00 ,Paid,Seth
1463,17-Apr,Applied Materials, $67.00 ,Paid,Calli
1464,17-Apr,Kroger, $233.00 ,Paid,Seth
1465,17-Apr,Digi-Key, $77.00 ,Paid,Seth
1466,17-Apr,United Services Automobile Association, $82.00 ,Paid,Seth
1467,17-Apr,Converse Shoes, $434.00 ,Paid,Sam
1468,17-Apr,Aetna, $325.00 ,Paid,Calli
1469,17-Apr,Calpine, $226.00 ,Paid,Seth
1470,17-Apr,Boeing, $453.00 ,Paid,Sam
1471,17-Apr,AT&T, $123.00 ,Paid,Seth
1472,17-Apr,H-E-B, $382.00 ,Paid,Calli
1473,17-Apr,"Dell, Inc.", $42.00 ,Paid,Calli
1474,17-Apr,Babcock & Wilcox, $174.00 ,Paid,Seth
1475,17-Apr,Kellogg Company, $159.00 ,Paid,Chris
1476,18-Apr,Southern California Edison, $375.00 ,Paid,Seth
1477,18-Apr,Service Corporation International (SCI), $280.00 ,Paid,Calli
1478,18-Apr,Computer Associates, $100.00 ,Paid,Calli
1479,18-Apr,Eli Lilly and Company, $115.00 ,Paid,Seth
1480,18-Apr,Delta Air Lines, $316.00 ,Paid,Chris
1481,18-Apr,Miro Technologies, $370.00 ,Paid,Chris
1482,18-Apr,Novell, $165.00 ,Paid,Chris
1483,18-Apr,Colgate-Palmolive, $325.00 ,Paid,Calli
1484,18-Apr,Walgreens, $289.00 ,Paid,Seth
1485,18-Apr,Kohler, $201.00 ,Paid,Seth
1486,18-Apr,RadioShack, $278.00 ,Paid,Seth
1487,18-Apr,ChevronTexaco, $473.00 ,Paid,Calli
1488,18-Apr,American Greetings, $166.00 ,Paid,Sam
1489,18-Apr,Lucasfilm, $485.00 ,Paid,Seth
1490,18-Apr,Unisys, $189.00 ,Paid,Calli
1491,18-Apr,General Dynamics, $38.00 ,Paid,Seth
1492,18-Apr,Exelon Corporation, $129.00 ,Paid,Seth
1493,18-Apr,iRobot, $265.00 ,Paid,Calli
1494,18-Apr,ION Media Networks, $490.00 ,Paid,Seth
1495,18-Apr,ACN Inc., $117.00 ,Paid,Seth
1496,18-Apr,Lamina Ceramics, $469.00 ,Paid,Sam
1497,18-Apr,Motorola, $5.00 ,Paid,Calli
1498,18-Apr,American Express, $408.00 ,Paid,Calli
1499,19-Apr,Pacific Gas & Electric Company (PG&E), $401.00 ,Paid,Seth
1500,19-Apr,Deere & Company, $24.00 ,Paid,Chris
1501,19-Apr,Safeway Inc., $156.00 ,Paid,Seth
1502,19-Apr,Apple Inc., $468.00 ,Paid,Calli
1503,19-Apr,i-flex Solutions, $378.00 ,Paid,Seth
1504,19-Apr,Rockwell Collins, $498.00 ,Paid,Seth
1505,19-Apr,Energy East, $375.00 ,Paid,Calli
1506,19-Apr,Trinity Industries Inc., $289.00 ,Paid,Seth
1507,19-Apr,Mars Incorporated, $284.00 ,Paid,Seth
1508,19-Apr,Autodesk, $472.00 ,Paid,Calli
1509,19-Apr,The Walt Disney Company, $457.00 ,Void,Seth
1510,19-Apr,Amiga, $443.00 ,Paid,Chris
1511,19-Apr,DuPont (E.I. du Pont de Nemours), $50.00 ,Paid,Seth
1512,19-Apr,Acme Brick Company, $316.00 ,Paid,Chris
1513,19-Apr,Martha Stewart Living Omnimedia, $294.00 ,Paid,Seth
1514,19-Apr,Wal-Mart, $387.00 ,Paid,Sam
1515,20-Apr,Gateway Computers, $68.00 ,Paid,Chris
1516,20-Apr,John Deere, $376.00 ,Paid,Calli
1517,20-Apr,United Parcel Service, $295.00 ,Void,Chris
1518,20-Apr,Viacom, $36.00 ,Paid,Calli
1519,20-Apr,Entergy, $121.00 ,Void,Sam
1520,20-Apr,ACCO Brands, $111.00 ,Paid,Seth
1521,20-Apr,ASARCO (American Smelting And Refining Company), $353.00 ,Paid,Calli
1522,20-Apr,UBU Productions, $279.00 ,Paid,Seth
1523,20-Apr,Enterprise GP Holdings, $374.00 ,Paid,Seth
1524,20-Apr,Global Insight, $73.00 ,Paid,Seth
1525,20-Apr,CNA, $146.00 ,Paid,Seth
1526,20-Apr,Ephlux, $40.00 ,Paid,Seth
1527,20-Apr,CNET, $108.00 ,Paid,Sam
1528,20-Apr,Belkin, $485.00 ,Paid,Calli
1529,20-Apr,Pinnacle Systems, $86.00 ,Paid,Calli
1530,20-Apr,"Sterling Ledet & Associates, Inc.", $342.00 ,Paid,Sam
1531,20-Apr,Sequoia Voting Systems, $187.00 ,Paid,Calli
1532,20-Apr,Home Depot, $396.00 ,Paid,Seth
1533,20-Apr,SGI, $215.00 ,Paid,Seth
1534,20-Apr,Pfizer, $126.00 ,Paid,Seth
1535,21-Apr,Browser Media, $439.00 ,Paid,Calli
1536,21-Apr,U.S Cellular, $404.00 ,Paid,Calli
1537,21-Apr,Beaner's Gourmet Coffee, $286.00 ,Paid,Seth
1538,21-Apr,VIZ Media, $226.00 ,Paid,Calli
1539,21-Apr,Nationwide Insurance, $381.00 ,Paid,Calli
1540,21-Apr,Dow Jones & Company, $208.00 ,Paid,Seth
1541,21-Apr,Skype, $177.00 ,Paid,Calli
1542,21-Apr,US Airways, $157.00 ,Paid,Calli
1543,21-Apr,New Era Tickets, $272.00 ,Paid,Seth
1544,21-Apr,Turner Entertainment, $259.00 ,Paid,Seth
1545,21-Apr,Limited Brands, $288.00 ,Paid,Seth
1546,21-Apr,AskMeNow, $237.00 ,Paid,Seth
1547,21-Apr,Stewart-Warner Instrument Company, $92.00 ,Paid,Seth
1548,21-Apr,Price Waterhouse Coopers, $13.00 ,Paid,Calli
1549,21-Apr,Hewlett-Packard, $187.00 ,Paid,Chris
1550,21-Apr,Walt Disney Company, $340.00 ,Paid,Calli
1551,21-Apr,U.S. Robotics, $37.00 ,Paid,Calli
1552,21-Apr,Costco, $202.00 ,Paid,Calli
1553,21-Apr,EMC Corporation, $302.00 ,Paid,Calli
1554,22-Apr,Quantrix, $248.00 ,Paid,Seth
1555,22-Apr,Citrix, $185.00 ,Paid,Chris
1556,22-Apr,ADC Telecommunications, $102.00 ,Paid,Seth
1557,22-Apr,Fidelity Investments, $422.00 ,Paid,Seth
1558,22-Apr,The Weinstein Company, $386.00 ,Paid,Sam
1559,22-Apr,Erie Insurance Group, $197.00 ,Paid,Seth
1560,22-Apr,Dresser Industries, $189.00 ,Paid,Seth
1561,22-Apr,Warner Bros. Entertainment, $440.00 ,Paid,Chris
1562,22-Apr,Blockbuster Video, $244.00 ,Paid,Chris
1563,22-Apr,Journal Communications, $27.00 ,Paid,Sam
1564,22-Apr,O'Reilly Media, $59.00 ,Paid,Calli
1565,22-Apr,Amy's Kitchen, $221.00 ,Paid,Calli
1566,22-Apr,Polaroid Corporation, $179.00 ,Paid,Calli
1567,22-Apr,STX, $63.00 ,Paid,Sam
1568,22-Apr,AMD, $421.00 ,Paid,Sam
1569,22-Apr,Xerox, $307.00 ,Paid,Calli
1570,22-Apr,Marathon Oil, $194.00 ,Paid,Seth
1571,22-Apr,Washington Mutual, $45.00 ,Paid,Sam
1572,23-Apr,Goldman Sachs, $498.00 ,Paid,Calli
1573,23-Apr,Interstate Batteries, $379.00 ,Paid,Calli
1574,23-Apr,Lockheed Martin, $480.00 ,Paid,Seth
1575,23-Apr,Verizon Wireless, $125.00 ,Paid,Calli
1576,23-Apr,Goodyear Tire and Rubber Company, $421.00 ,Paid,Chris
1577,23-Apr,MCI, $319.00 ,Paid,Seth
1578,23-Apr,Interplay Entertainment, $262.00 ,Paid,Calli
1579,23-Apr,Bradley Pharmaceuticals, $224.00 ,Paid,Seth
1580,23-Apr,Paramount Pictures, $332.00 ,Void,Seth
1581,23-Apr,Burlington Northern Santa Fe, $380.00 ,Paid,Seth
1582,23-Apr,Quest Software, $373.00 ,Paid,Seth
1583,23-Apr,Express Scripts Incorporated, $401.00 ,Paid,Calli
1584,23-Apr,Estee Lauder Companies, $444.00 ,Paid,Calli
1585,23-Apr,Publix, $222.00 ,Paid,Seth
1586,23-Apr,Oracle Corporation, $483.00 ,Paid,Seth
1587,23-Apr,Convergys Corp., $448.00 ,Paid,Calli
1588,23-Apr,Principal Financial Group, $408.00 ,Paid,Seth
1589,23-Apr,"PalmSource, Inc.", $152.00 ,Paid,Seth
1590,23-Apr,American Apparel, $486.00 ,Paid,Seth
1591,23-Apr,Capital One, $43.00 ,Paid,Chris
1592,23-Apr,Merck and Company, $416.00 ,Paid,Chris
1593,24-Apr,Hachette Filipacchi Media U.S., $80.00 ,Paid,Calli
1594,24-Apr,Activision, $89.00 ,Paid,Chris
1595,24-Apr,Ariba, $67.00 ,Paid,Seth
1596,24-Apr,Mutual of Omaha, $495.00 ,Paid,Seth
1597,24-Apr,Federal Home Loan Mortgage Corporation, $176.00 ,Paid,Chris
1598,24-Apr,UTStarcom, $348.00 ,Paid,Calli
1599,24-Apr,Discovery Communications, $70.00 ,Paid,Seth
1600,24-Apr,Sun Microsystems, $310.00 ,Paid,Calli
1601,24-Apr,Allen Organ, $151.00 ,Void,Chris
1602,24-Apr,Alcoa, $209.00 ,Paid,Calli
'''

