####################################################################################
#                                                                                  
# Copyright (c) 2008 Dallin P. Regehr<dallinregehrATgmailDOTcom>             
#                                                                                  
# This deteclet is part of the purchasing or kickbacks wizards library.                     
#   Running the default data will show the following two invoices have fraud:
#   InvoiceNum                InvoiceAmt         CheckAmt
#  2483                       	   $2365	               $5365
#  2747                       	   $3542	               $9542                    
#                                                                                  
####################################################################################
# UPDATES:
# 
#
####################################################################################
#
#   STATUS: Review
#           
#
#    IDEAS/QUESTIONS/NOTES:
#
####################################################################################
from picalo import *

DETECTLET_STANDARD = 1.0

wizard = '''
<wizard>
  <page>
    Select the TABLE containing the purchasing invoices (probably the 
    purchasing table). 
    
    Invoice number and invoice amount columns will be needed.
    <parameter type="Table" variable="invoicetable"/>


    Select the TABLE containing payments. 
    
    It should have the columns: check number, 
    invoice number (it should have the same reference numbers as the table above), 
    and the check amounts.
    <parameter type="Table" variable="paymenttable"/>
  </page>
  <page>
    Select the COLUMN containing invoice numbers:
    <parameter type="Column" table="invoicetable" variable="purchInvoiceNum"/>
    Select the COLUMN containing invoice amounts:
    <parameter type="Column" table="invoicetable" variable="invoiceAmt"/>
  </page>
  <page>
    Select the COLUMN containing check numbers:
    <parameter type="Column" table="paymenttable" variable="checkNum"/>
    Select the COLUMN containing invoice numbers:
    <parameter type="Column" table="paymenttable" variable="pmtInvoiceNum"/>
  </page>
  <page>
    Select the COLUMN containing check amounts:
    <parameter type="Column" table="paymenttable" variable="checkAmt"/>
  </page>
</wizard>
'''

RESULTS_TEXT = '''\
    The results shown here are all the records that contain a discrepancy between the invoice
    amount and the check amount. If this table is empty then no problems were found!
'''


def run(invoicetable, paymenttable, purchInvoiceNum, invoiceAmt, checkNum, pmtInvoiceNum, checkAmt):
  '''A possible fraud in a company is for an employee to write a check for an amount greater than needed
  to pay a vendor. For example, an invoice from the purchasing department could show that $500 was to be
  sent to a certain vendor. The employee in charge of writing the check could write it for an additional 
  $100. He could then get the vendor to give him the cash or similar form of kickback. This fraud would be
  found by comparing the totals in purchasing and payment tables.
  
  This wizard first totals the purchasing and payment tables and compares their amounts. If there is no
  discrepancy then no results are shown and the fraud is nonexistant. (Note: If the time period covered by
  both tables is different then this detectlet won't work. Each entry in the purchasing table should have
  a corresponding entry in the payment table)
  
  If there is an inconsistancy between the two tables then the two are compared and the differing records
  are found and displayed as the results. The two tables are compared based on a corresponding invoice number
  or something similar. This is necessary to join the two tables.
  
  
  The purchasing table requires:
  
  - Invoice number, or something similar
  
  - Invoice amount 
  
  
  The payment table requires:
  
  - A check number column for identification
  
  - Invoice number that correspondes to the same invoices as the purchasing table
  
  - Check amount
  
  '''
  # validate the input data
  assert invoicetable != paymenttable, 'The two tables must be different. Please select the purchase and payment tables'
  assert purchInvoiceNum != invoiceAmt != pmtInvoiceNum != checkAmt, 'Selected columns cannot be the same. Please ensure you have selected different columns.'

  # total each table and compare
  invoiceTotal = 0
  for rec in invoicetable:
    invoiceTotal = invoiceTotal + rec[1]
  
  paymentTotal = 0  
  for rec in paymenttable:
    paymentTotal = paymentTotal + rec[2] # the payment table has 3 records, not two like the puchase table
    
    
  # create table
    results = Table([
      ('InvoiceNum',   unicode ),
      (invoiceAmt, number),
      (checkNum,    unicode),
      (checkAmt,    number),
      ('AmtDifference', number),
    ])
  
  # if there is a descrepancy, find the records that don't match and populate the table with them
  if invoiceTotal != paymentTotal:
    # join the two tables on the invoice number
    joinedTable = Simple.col_join(invoicetable, paymenttable, [purchInvoiceNum, pmtInvoiceNum])
    for record in joinedTable:
      # only display the records that disagree
      if record[invoiceAmt] != record[checkAmt]:
        rec = results.append()
        rec['InvoiceNum'] = record[purchInvoiceNum]
        rec[invoiceAmt] = record[invoiceAmt]
        rec[checkNum] = record[checkNum]
        rec[checkAmt] = record[checkAmt]
        rec['AmtDifference'] = record[checkAmt] - record[invoiceAmt]
  
  return results, RESULTS_TEXT

  
  
def example_input():
  '''Returns the eaxmple input table so the user can
     see what their input should look like'''
  import StringIO  # to emulate a file for load_csv
  table = load_csv(StringIO.StringIO(csvdata))
  table.set_type('InvoiceAmt', number)
  
  table2 = load_csv(StringIO.StringIO(csvdata2))
  table2.set_type('CheckAmt', number) 
  return table, table2
  
# This next part is not required, but it's easier to put the example data
# directly in this file so I don't have to worry about directories.

csvdata = '''\
InvoiceNum,InvoiceAmt
2335,2258
2336,4793
2337,5385
2338,10000
2339,9412
2340,6680
2341,1623
2342,8430
2343,862
2344,6574
2345,5728
2346,995
2347,1642
2348,4986
2349,2796
2350,7979
2351,9788
2352,6654
2353,5233
2354,2446
2355,8210
2356,762
2357,1503
2358,3702
2359,7744
2360,6568
2361,4521
2362,7997
2363,9374
2364,5208
2365,1687
2366,2561
2367,7631
2368,8257
2369,9348
2370,2212
2371,5659
2372,8073
2373,6503
2374,3735
2375,569
2376,7533
2377,4634
2378,5213
2379,8743
2380,1000
2381,4776
2382,5486
2383,7730
2384,1317
2385,5401
2386,8576
2387,1691
2388,4712
2389,3142
2390,9245
2391,8562
2392,9198
2393,1017
2394,5892
2395,2258
2396,3725
2397,2675
2398,2612
2399,1023
2400,1701
2401,4260
2402,2420
2403,2495
2404,6788
2405,7521
2406,1514
2407,2210
2408,7959
2409,3786
2410,6843
2411,4310
2412,4502
2413,9642
2414,596
2415,2024
2416,4746
2417,7031
2418,4686
2419,4544
2420,8892
2421,6456
2422,1818
2423,2684
2424,1938
2425,717
2426,6404
2427,1488
2428,9152
2429,9995
2430,4056
2431,1274
2432,4895
2433,1681
2434,3677
2435,2202
2436,8314
2437,6930
2438,5386
2439,1832
2440,2121
2441,7373
2442,8893
2443,4504
2444,2629
2445,9459
2446,2134
2447,5406
2448,6371
2449,4271
2450,6612
2451,8741
2452,2520
2453,7156
2454,5819
2455,2253
2456,6535
2457,1337
2458,3429
2459,9655
2460,6805
2461,4657
2462,4113
2463,6057
2464,6561
2465,7907
2466,5863
2467,6071
2468,7054
2469,7344
2470,6578
2471,650
2472,8691
2473,3783
2474,3089
2475,8847
2476,9753
2477,5135
2478,933
2479,6962
2480,9523
2481,6531
2482,3755
2483,2365
2484,6842
2485,8336
2486,5637
2487,2494
2488,6594
2489,4825
2490,7298
2491,2016
2492,8253
2493,1674
2494,6862
2495,8740
2496,7808
2497,1125
2498,2993
2499,5789
2500,659
2501,4134
2502,6010
2503,8528
2504,1705
2505,2275
2506,8185
2507,7282
2508,8722
2509,5857
2510,7769
2511,4412
2512,6221
2513,9021
2514,4182
2515,9216
2516,7820
2517,1958
2518,5140
2519,2071
2520,3462
2521,8516
2522,5111
2523,5595
2524,5189
2525,7876
2526,9685
2527,9654
2528,6936
2529,1987
2530,1092
2531,6313
2532,828
2533,7503
2534,4158
2535,8031
2536,7810
2537,4423
2538,8167
2539,4967
2540,8517
2541,5884
2542,718
2543,8424
2544,4529
2545,7085
2546,1509
2547,7245
2548,8852
2549,3770
2550,4901
2551,5931
2552,4822
2553,9954
2554,6444
2555,1001
2556,5131
2557,2159
2558,3327
2559,9562
2560,7690
2561,3678
2562,3808
2563,1898
2564,5789
2565,7949
2566,3206
2567,9625
2568,7651
2569,9424
2570,9004
2571,3089
2572,1327
2573,5034
2574,6757
2575,5243
2576,6046
2577,1773
2578,7702
2579,8176
2580,5403
2581,701
2582,4014
2583,2265
2584,5695
2585,6855
2586,6840
2587,530
2588,1329
2589,7952
2590,6296
2591,3244
2592,1459
2593,8217
2594,803
2595,1776
2596,7727
2597,3491
2598,6597
2599,9939
2600,9435
2601,2149
2602,603
2603,2305
2604,9683
2605,8866
2606,4909
2607,7930
2608,4468
2609,3951
2610,4397
2611,6210
2612,8805
2613,4066
2614,4766
2615,5764
2616,6102
2617,3956
2618,6864
2619,7032
2620,4569
2621,4469
2622,9332
2623,9739
2624,1419
2625,5880
2626,2558
2627,2816
2628,7034
2629,9853
2630,1848
2631,831
2632,1092
2633,2310
2634,8291
2635,1308
2636,3316
2637,7000
2638,7623
2639,4079
2640,1312
2641,596
2642,7973
2643,7034
2644,2774
2645,1343
2646,1437
2647,3655
2648,4393
2649,1284
2650,3237
2651,774
2652,523
2653,3268
2654,5810
2655,5674
2656,8622
2657,9365
2658,1476
2659,1874
2660,7909
2661,1407
2662,5228
2663,6650
2664,6403
2665,4617
2666,5419
2667,2275
2668,1091
2669,4046
2670,1861
2671,2456
2672,4081
2673,6408
2674,7607
2675,4858
2676,6055
2677,6975
2678,8558
2679,651
2680,1496
2681,3836
2682,5161
2683,8215
2684,8324
2685,7847
2686,9869
2687,8709
2688,3989
2689,3684
2690,6888
2691,3019
2692,2423
2693,2491
2694,4402
2695,2744
2696,2438
2697,8959
2698,8805
2699,3101
2700,4074
2701,2492
2702,9377
2703,7738
2704,3647
2705,4436
2706,8891
2707,4063
2708,4392
2709,9802
2710,5956
2711,3124
2712,7822
2713,4456
2714,8456
2715,6572
2716,3981
2717,4606
2718,8022
2719,4701
2720,8498
2721,886
2722,4917
2723,9988
2724,4650
2725,8095
2726,6022
2727,8269
2728,3961
2729,7368
2730,7462
2731,6320
2732,9693
2733,654
2734,5739
2735,4852
2736,9242
2737,5805
2738,9631
2739,7425
2740,7129
2741,9141
2742,3108
2743,3196
2744,5054
2745,2492
2746,5037
2747,3542
2748,8411
2749,6941
2750,8143
2751,3440
2752,2474
2753,6480
2754,8166
2755,1087
2756,5306
2757,7154
2758,7534
2759,8716
2760,1006
2761,5284
2762,6147
2763,1229
2764,5996
2765,846
2766,8793
2767,6219
2768,9162
2769,9700
2770,8319
2771,8914
2772,6979
2773,8700
2774,8946
2775,7611
2776,1374
2777,7043
2778,2800
2779,7319
2780,933
2781,1307
2782,9039
2783,7292
2784,8203
2785,6857
2786,6774
2787,7813
2788,5942
2789,8757
2790,7157
2791,2496
2792,1270
2793,3235
2794,6410
2795,5666
2796,6349
2797,6045
2798,762
2799,500
2800,3232
2801,8409
2802,4163
2803,3635
2804,9469
2805,4468
2806,4744
2807,1616
2808,3968
2809,4139
2810,6136
2811,2007
2812,5569
2813,1958
2814,8391
2815,4128
2816,5206
2817,2802
2818,7828
2819,5417
2820,1802
2821,2667
2822,5324
2823,6028
2824,6717
2825,617
2826,5470
2827,4841
2828,8712
2829,6034
2830,7332
2831,2702
2832,1035
2833,698
2834,5063
2835,1234
2836,7346
2837,5601
2838,6366
2839,9981
2840,5467
2841,6624
2842,9382
2843,516
2844,4248
2845,1383
2846,2078
2847,3252
2848,4371
2849,2708
2850,1198
2851,3777
2852,1000
2853,5199
2854,1307
2855,2922
2856,2856
2857,3796
2858,5435
2859,945
2860,2367
2861,2043
2862,7446
2863,9030
2864,2605
2865,8058
2866,7021
2867,7553
2868,5887
2869,6254
2870,1733
2871,8480
2872,5933
2873,8443
2874,3609
2875,6287
2876,4266
2877,973
2878,6173
2879,6080
2880,1080
2881,7352
2882,2927
2883,5355
2884,6657
'''

csvdata2 = '''\
CheckNum,InvoiceNum,CheckAmt
5230,2335,2258
5231,2336,4793
5232,2337,5385
5233,2338,10000
5234,2339,9412
5235,2340,6680
5236,2341,1623
5237,2342,8430
5238,2343,862
5239,2344,6574
5240,2345,5728
5241,2346,995
5242,2347,1642
5243,2348,4986
5244,2349,2796
5245,2350,7979
5246,2351,9788
5247,2352,6654
5248,2353,5233
5249,2354,2446
5250,2355,8210
5251,2356,762
5252,2357,1503
5253,2358,3702
5254,2359,7744
5255,2360,6568
5256,2361,4521
5257,2362,7997
5258,2363,9374
5259,2364,5208
5260,2365,1687
5261,2366,2561
5262,2367,7631
5263,2368,8257
5264,2369,9348
5265,2370,2212
5266,2371,5659
5267,2372,8073
5268,2373,6503
5269,2374,3735
5270,2375,569
5271,2376,7533
5272,2377,4634
5273,2378,5213
5274,2379,8743
5275,2380,1000
5276,2381,4776
5277,2382,5486
5278,2383,7730
5279,2384,1317
5280,2385,5401
5281,2386,8576
5282,2387,1691
5283,2388,4712
5284,2389,3142
5285,2390,9245
5286,2391,8562
5287,2392,9198
5288,2393,1017
5289,2394,5892
5290,2395,2258
5291,2396,3725
5292,2397,2675
5293,2398,2612
5294,2399,1023
5295,2400,1701
5296,2401,4260
5297,2402,2420
5298,2403,2495
5299,2404,6788
5300,2405,7521
5301,2406,1514
5302,2407,2210
5303,2408,7959
5304,2409,3786
5305,2410,6843
5306,2411,4310
5307,2412,4502
5308,2413,9642
5309,2414,596
5310,2415,2024
5311,2416,4746
5312,2417,7031
5313,2418,4686
5314,2419,4544
5315,2420,8892
5316,2421,6456
5317,2422,1818
5318,2423,2684
5319,2424,1938
5320,2425,717
5321,2426,6404
5322,2427,1488
5323,2428,9152
5324,2429,9995
5325,2430,4056
5326,2431,1274
5327,2432,4895
5328,2433,1681
5329,2434,3677
5330,2435,2202
5331,2436,8314
5332,2437,6930
5333,2438,5386
5334,2439,1832
5335,2440,2121
5336,2441,7373
5337,2442,8893
5338,2443,4504
5339,2444,2629
5340,2445,9459
5341,2446,2134
5342,2447,5406
5343,2448,6371
5344,2449,4271
5345,2450,6612
5346,2451,8741
5347,2452,2520
5348,2453,7156
5349,2454,5819
5350,2455,2253
5351,2456,6535
5352,2457,1337
5353,2458,3429
5354,2459,9655
5355,2460,6805
5356,2461,4657
5357,2462,4113
5358,2463,6057
5359,2464,6561
5360,2465,7907
5361,2466,5863
5362,2467,6071
5363,2468,7054
5364,2469,7344
5365,2470,6578
5366,2471,650
5367,2472,8691
5368,2473,3783
5369,2474,3089
5370,2475,8847
5371,2476,9753
5372,2477,5135
5373,2478,933
5374,2479,6962
5375,2480,9523
5376,2481,6531
5377,2482,3755
5378,2483,5365
5379,2484,6842
5380,2485,8336
5381,2486,5637
5382,2487,2494
5383,2488,6594
5384,2489,4825
5385,2490,7298
5386,2491,2016
5387,2492,8253
5388,2493,1674
5389,2494,6862
5390,2495,8740
5391,2496,7808
5392,2497,1125
5393,2498,2993
5394,2499,5789
5395,2500,659
5396,2501,4134
5397,2502,6010
5398,2503,8528
5399,2504,1705
5400,2505,2275
5401,2506,8185
5402,2507,7282
5403,2508,8722
5404,2509,5857
5405,2510,7769
5406,2511,4412
5407,2512,6221
5408,2513,9021
5409,2514,4182
5410,2515,9216
5411,2516,7820
5412,2517,1958
5413,2518,5140
5414,2519,2071
5415,2520,3462
5416,2521,8516
5417,2522,5111
5418,2523,5595
5419,2524,5189
5420,2525,7876
5421,2526,9685
5422,2527,9654
5423,2528,6936
5424,2529,1987
5425,2530,1092
5426,2531,6313
5427,2532,828
5428,2533,7503
5429,2534,4158
5430,2535,8031
5431,2536,7810
5432,2537,4423
5433,2538,8167
5434,2539,4967
5435,2540,8517
5436,2541,5884
5437,2542,718
5438,2543,8424
5439,2544,4529
5440,2545,7085
5441,2546,1509
5442,2547,7245
5443,2548,8852
5444,2549,3770
5445,2550,4901
5446,2551,5931
5447,2552,4822
5448,2553,9954
5449,2554,6444
5450,2555,1001
5451,2556,5131
5452,2557,2159
5453,2558,3327
5454,2559,9562
5455,2560,7690
5456,2561,3678
5457,2562,3808
5458,2563,1898
5459,2564,5789
5460,2565,7949
5461,2566,3206
5462,2567,9625
5463,2568,7651
5464,2569,9424
5465,2570,9004
5466,2571,3089
5467,2572,1327
5468,2573,5034
5469,2574,6757
5470,2575,5243
5471,2576,6046
5472,2577,1773
5473,2578,7702
5474,2579,8176
5475,2580,5403
5476,2581,701
5477,2582,4014
5478,2583,2265
5479,2584,5695
5480,2585,6855
5481,2586,6840
5482,2587,530
5483,2588,1329
5484,2589,7952
5485,2590,6296
5486,2591,3244
5487,2592,1459
5488,2593,8217
5489,2594,803
5490,2595,1776
5491,2596,7727
5492,2597,3491
5493,2598,6597
5494,2599,9939
5495,2600,9435
5496,2601,2149
5497,2602,603
5498,2603,2305
5499,2604,9683
5500,2605,8866
5501,2606,4909
5502,2607,7930
5503,2608,4468
5504,2609,3951
5505,2610,4397
5506,2611,6210
5507,2612,8805
5508,2613,4066
5509,2614,4766
5510,2615,5764
5511,2616,6102
5512,2617,3956
5513,2618,6864
5514,2619,7032
5515,2620,4569
5516,2621,4469
5517,2622,9332
5518,2623,9739
5519,2624,1419
5520,2625,5880
5521,2626,2558
5522,2627,2816
5523,2628,7034
5524,2629,9853
5525,2630,1848
5526,2631,831
5527,2632,1092
5528,2633,2310
5529,2634,8291
5530,2635,1308
5531,2636,3316
5532,2637,7000
5533,2638,7623
5534,2639,4079
5535,2640,1312
5536,2641,596
5537,2642,7973
5538,2643,7034
5539,2644,2774
5540,2645,1343
5541,2646,1437
5542,2647,3655
5543,2648,4393
5544,2649,1284
5545,2650,3237
5546,2651,774
5547,2652,523
5548,2653,3268
5549,2654,5810
5550,2655,5674
5551,2656,8622
5552,2657,9365
5553,2658,1476
5554,2659,1874
5555,2660,7909
5556,2661,1407
5557,2662,5228
5558,2663,6650
5559,2664,6403
5560,2665,4617
5561,2666,5419
5562,2667,2275
5563,2668,1091
5564,2669,4046
5565,2670,1861
5566,2671,2456
5567,2672,4081
5568,2673,6408
5569,2674,7607
5570,2675,4858
5571,2676,6055
5572,2677,6975
5573,2678,8558
5574,2679,651
5575,2680,1496
5576,2681,3836
5577,2682,5161
5578,2683,8215
5579,2684,8324
5580,2685,7847
5581,2686,9869
5582,2687,8709
5583,2688,3989
5584,2689,3684
5585,2690,6888
5586,2691,3019
5587,2692,2423
5588,2693,2491
5589,2694,4402
5590,2695,2744
5591,2696,2438
5592,2697,8959
5593,2698,8805
5594,2699,3101
5595,2700,4074
5596,2701,2492
5597,2702,9377
5598,2703,7738
5599,2704,3647
5600,2705,4436
5601,2706,8891
5602,2707,4063
5603,2708,4392
5604,2709,9802
5605,2710,5956
5606,2711,3124
5607,2712,7822
5608,2713,4456
5609,2714,8456
5610,2715,6572
5611,2716,3981
5612,2717,4606
5613,2718,8022
5614,2719,4701
5615,2720,8498
5616,2721,886
5617,2722,4917
5618,2723,9988
5619,2724,4650
5620,2725,8095
5621,2726,6022
5622,2727,8269
5623,2728,3961
5624,2729,7368
5625,2730,7462
5626,2731,6320
5627,2732,9693
5628,2733,654
5629,2734,5739
5630,2735,4852
5631,2736,9242
5632,2737,5805
5633,2738,9631
5634,2739,7425
5635,2740,7129
5636,2741,9141
5637,2742,3108
5638,2743,3196
5639,2744,5054
5640,2745,2492
5641,2746,5037
5642,2747,9542
5643,2748,8411
5644,2749,6941
5645,2750,8143
5646,2751,3440
5647,2752,2474
5648,2753,6480
5649,2754,8166
5650,2755,1087
5651,2756,5306
5652,2757,7154
5653,2758,7534
5654,2759,8716
5655,2760,1006
5656,2761,5284
5657,2762,6147
5658,2763,1229
5659,2764,5996
5660,2765,846
5661,2766,8793
5662,2767,6219
5663,2768,9162
5664,2769,9700
5665,2770,8319
5666,2771,8914
5667,2772,6979
5668,2773,8700
5669,2774,8946
5670,2775,7611
5671,2776,1374
5672,2777,7043
5673,2778,2800
5674,2779,7319
5675,2780,933
5676,2781,1307
5677,2782,9039
5678,2783,7292
5679,2784,8203
5680,2785,6857
5681,2786,6774
5682,2787,7813
5683,2788,5942
5684,2789,8757
5685,2790,7157
5686,2791,2496
5687,2792,1270
5688,2793,3235
5689,2794,6410
5690,2795,5666
5691,2796,6349
5692,2797,6045
5693,2798,762
5694,2799,500
5695,2800,3232
5696,2801,8409
5697,2802,4163
5698,2803,3635
5699,2804,9469
5700,2805,4468
5701,2806,4744
5702,2807,1616
5703,2808,3968
5704,2809,4139
5705,2810,6136
5706,2811,2007
5707,2812,5569
5708,2813,1958
5709,2814,8391
5710,2815,4128
5711,2816,5206
5712,2817,2802
5713,2818,7828
5714,2819,5417
5715,2820,1802
5716,2821,2667
5717,2822,5324
5718,2823,6028
5719,2824,6717
5720,2825,617
5721,2826,5470
5722,2827,4841
5723,2828,8712
5724,2829,6034
5725,2830,7332
5726,2831,2702
5727,2832,1035
5728,2833,698
5729,2834,5063
5730,2835,1234
5731,2836,7346
5732,2837,5601
5733,2838,6366
5734,2839,9981
5735,2840,5467
5736,2841,6624
5737,2842,9382
5738,2843,516
5739,2844,4248
5740,2845,1383
5741,2846,2078
5742,2847,3252
5743,2848,4371
5744,2849,2708
5745,2850,1198
5746,2851,3777
5747,2852,1000
5748,2853,5199
5749,2854,1307
5750,2855,2922
5751,2856,2856
5752,2857,3796
5753,2858,5435
5754,2859,945
5755,2860,2367
5756,2861,2043
5757,2862,7446
5758,2863,9030
5759,2864,2605
5760,2865,8058
5761,2866,7021
5762,2867,7553
5763,2868,5887
5764,2869,6254
5765,2870,1733
5766,2871,8480
5767,2872,5933
5768,2873,8443
5769,2874,3609
5770,2875,6287
5771,2876,4266
5772,2877,973
5773,2878,6173
5774,2879,6080
5775,2880,1080
5776,2881,7352
5777,2882,2927
5778,2883,5355
5779,2884,6657
'''