# Version 1.0
#
# Note: Testing this requires using the Web Services Key "0"
#   A side effect of this is that the web service will not let you do a lot of searches
#   in a row.  For this reason I cut the dummy data down significantly to allow testing.
#   If a license was obtained, the testing would work with the long list of data I 
#   have prepared.
#
# I'm going to try to get this company to bundle this detectlet with their Web Service.

####################################################################################
#                                                                                  
# Copyright (c) 2008 by Grant Gordon      
#                                                                           
# This Detectlet is part of the Payroll Frauds Library
#
# Running this Detectlet with the example data yields the following results:
# +------------+-----------+---------------+----------+----------------+-----------+
# | EmployeeID | FirstName | MiddleInitial | LastName |    Address     |    SSN    |
# +------------+-----------+---------------+----------+----------------+-----------+
# |      234.0 | Mark      | W             | Smith    | 453 Eagle Road | 562100296 |
# +------------+-----------+---------------+----------+----------------+-----------+
####################################################################################


DETECTLET_STANDARD = 1.0

from picalo import *
from urllib import *
from xml.dom import minidom

wizard = '''
<wizard>
  <page>
    Select the TABLE containing Employee records:
    <parameter type="Table" variable="tbl_employees"/>
  </page>
  <page>
    Select the COLUMN containing Employees' Social Security Numbers:
    <parameter type="Column" table="tbl_employees" variable="clm_ssn"/>
  </page>
  <page>
    Enter your CDYNE Death Index Web Service License Key:
    <parameter type="string" variable="license"/>
  </page>
</wizard>
'''

def getText(node):
    rc = ""
    if node.nodeType == node.TEXT_NODE:
        rc = rc + node.data
    return rc
    
def run(tbl_employees,clm_ssn,license):
    '''This detectlet compares all of your employees with the Social Security Death Index
    to see if any of them are using SSNs of deceased individuals. \n
    To use it, you must have a valid License Key for CDYNE's Social Security Death Index Web Service.\n
    Simply choose the table that contains your employee information and the column
    that contains their social security number, enter your License Key, and this detectlet will do the rest!\n\n
    (You can buy access to this web service at http://www.cdyne.com)
    '''
    RESULTS_TEXT = '''There were no matches.  No employee's seem to be using SSNs of deceased individuals.'''

    RESULTS_COUNT = 0
    
    # Create a results table with the same columns as the original Employee table
    tbl_work = tbl_employees[:]
    clm_names = tbl_work.get_column_names()
    clm_list = tbl_work.get_columns()
    clm_list_results = []
    
    for n, clm in enumerate(clm_names):
        clm_list_results.append((clm, clm_list[n].get_type()))
    
    tbl_results = Table(clm_list_results)
    
    # Iterate through all employees
    for emp in tbl_work:
        
        values = {'ssn':emp[clm_ssn],'LicenseKey':license}
        ws_response = ''
        
        # Use the web service to check this employee's SSN for a match 
        try:
            ws_response = urlopen('http://ws.cdyne.com/DeathIndex/QueryDeathIndex.asmx/DeceasedBySSN',urlencode(values))
        except:
            raise
        
        if ws_response !='':
            dom = minidom.parse(ws_response)
            
            #Get the boolean in the response to see if it's true
            results = dom.getElementsByTagName("Match")[0]
            
            # If it is, add this employee to the results table, and modify the results text
            if getText(results.childNodes[0]) == 'true':
                RESULTS_COUNT = 1 + RESULTS_COUNT
                RESULTS_TEXT = str(RESULTS_COUNT) + " matches found.  Employees using dead SSNs are listed in the results table."
                tbl_results.append(emp)
    return tbl_results, RESULTS_TEXT
    
#-----------------------------------------------------------------------------------#
#           CSV Test Data
#-----------------------------------------------------------------------------------#
csvdata = '''\
EmployeeID,FirstName,MiddleInitial,LastName,Address,SSN
234,Mark,W,Smith,453 Eagle Road,562100296
235,Stephen,C,Lehman,645 Webster Street,523366452
236,Matthew,A,Harris,886 East Washington St.,652531173
237,Carol,H,Harper,334 Lakeside Rd.,536904399
'''
# Note: unless you have a paid account you cannot use all the data or the web service tester will yell at you.
#       For this reason I cut the dummy data down to size.  Put it back together if you have an account.
'''
238,Connie,G,Forde,632 Pine Lane,187852446
239,John,E,Hawkins,45 Oak Ave.,738828571
240,Daniel,T,Haynes,37 West Nottingham Avenue,782761572
241,Joanne,U,Pearson,7453 Littlejohn Road,712372228
242,David,K,Taylor,43 Gunshoot Street,733223144
243,Mike,G,Shook,643 N. Arline St.,315137763
244,Carolyn,S,Tabor,431 Bittersweet Rd.,261855555
245,Gail,D,Cole,341 N. Harvest Road,682248185
246,Joe,F,Cochran,1686 Spruce Street,666758252
247,Laura,E,Cobb,4689 Sunny St.,485746658
248,Beth,S,Butler,842 Thorton Rd.,852338537
249,Jewel,D,McMullan,2817 S. Beech Lane,423338418
250,Harold,G,Conery,3488 Spivey Ave.,316456663
251,Ernie,B,Long,2002 Wolf Avenue,812514588
252,Todd,C,Nickels,1498 Lion Road,453348334
253,Bucky,C,O'Brian,2343 10th Street,837436258
254,Frank,N,Fulton,2979 East Richardson Road,183227322
255,Linda,M,Nelson,4766 Bunker Hill Street,518231524
256,Justin,H,Miller,4327 Robin Hood St.,146886372
257,Betty,F,Norris,1618 Sunset Rd.,426447877
258,Billy,S,Buckner,1515 Mill Lane,782877478
259,Bobby,A,Crosland,2622 Sonia Ave.,488122546
260,Brian,D,Snow,640 Jolly Avenue,388567445
261,Charles,J,Sherril,4491 Cypress Rd.,331276568
262,Fred,K,Simmons,855 W. Manor Road,563226416
263,James,L,Skinner,377 Alabama Street,337438327
264,Kevin,W,Snyder,436 S. Mississippi St.,244544128
265,Robert,C,Sneed,355 E. River Rd.,445138837
266,William,A,Wright,3979 17th Lane,763815413
267,Max,H,Warren,4570 N. Military Ave.,757588612
268,Jim,G,Woods,1687 University Avenue,563282754
269,Benjamin,E,Womack,1100 Main Rd.,285758674
270,Jennifer,T,Wilson,73 Justin Road,582565211
271,Jane,U,Wind,2703 Holly Hills Street,575511836
272,Rose,K,Wise,172 Greentree St.,116613646
273,Mickey,G,Woodard,4555 Old Yorkville Rd.,623657751
274,Annette,S,Williamson,1473 East Emerald Road,432573324
275,George,D,White,892 Steens Street,471563245
276,Terry,F,Washington,1285 Plum St.,261241822
277,Debbie,E,DuFrene,3784 Dogwood Rd.,182127674
278,Barry,S,Baker,4189 N. Gipson Lane,621256376
279,Gertrude,D,Bailey,4842 West Point Ave.,431367626
280,Harris,G,Ashford,70 Locksley Way Avenue,547654251
281,Larry,B,Andrews,3885 Maid Marian Rd.,276771684
282,Sharon,C,Anderson,4078 Reed Lane,651554212
283,Diane,C,Douglas,4913 North Ave.,858875354
284,Mary,N,Dickson,2220 South Avenue,787528888
285,Randy,M,Polk,2424 East Road,652182453
286,Timothy,H,Henderson,4540 West Point Street,653574216
287,Wayne,F,Logan,1891 Yeates St.,112382132
288,Richey,S,Cunnigham,534 East Columbus Road,778844871
289,Gary,A,Davis,1378 Aztec Street,325772333
290,Chris,D,Dallas,2564 Campus View St.,264267411
291,Kerry,J,Dailey,3430 N. Montgomery Rd.,717218821
292,Eloise,K,Cumberland,1515 North Jackson Lane,663737136
293,Glenn,L,Graham,504 N. Lincoln Ave.,338386274
294,Lucy,W,Hunt,3601 Carter Avenue,253223331
295,Patrick,C,Williams,443 E. Bush St.,585328121
296,Lewis,A,Scoggin,522 Starr St.,178238367
297,Paul,D,Clemons,4473 Wood Road,776273823
298,Sarah,G,Johnson,4723 Hartness Street,378618228
299,Earl,E,Ivy,4038 S. Maple St.,415712263
300,Harry,T,Jack,797 Oak Rd.,542468385
301,Drew,U,Bryant,1933 Chestnut Lane,524835817
302,Ally,K,Walker,3244 West Spivey Ave.,837235322
303,Haley,G,Jamison,2136 East Wolf Avenue,851576516
304,Lee,S,Jefferson,2483 W. Lion St.,617847813
305,Kimberly,D,James,1635 10th Ave.,282588888
306,Ronald,F,Brown,1095 Richardson Avenue,674358313
307,Rhonda,E,Ballard,2821 North Bunker Hill Street,174215783
308,Jusy,S,Green,1943 Robin Hood Road,553875322
309,Jessie,D,Glover,3480 Sunset Street,442845544
310,Cliff,G,Glaspe,2807 E. Mill St.,273281772
311,Frances,B,Franklin,4337 Sonia Road,188773387
312,Michael,C,Ford,2257 Jolly Street,344842144
313,Lisa,C,Grace,4602 Cypress St.,338583585
314,Ruth,N,Gregg,1678 S. Manor Rd.,128213235
315,Malcom,M,Griffin,1291 Alabama Lane,412188184
316,Keith,H,Nicholson,4423 N. Mississippi Ave.,364185621
317,Jeff,F,Moore,778 River Avenue,446514435
318,Zac,S,Wallace,2979 River St.,533532687
319,Eric,A,McCann,2651 Lakeside Rd.,323841548
320,Trey,D,McPhail,2153 North Pine Lane,283151143
321,Doris,J,Hazzard,1642 Oak Ave.,417157145
322,Elliot,K,Makamson,4983 East Nottingham Avenue,248116885
323,Ashley,L,McGwire,932 Jeff Peay Avenue,556128847
'''

def example_input():
  '''Returns the example input table so the user can
     see what their input should look like'''
  import StringIO  # to emulate a file for load_csv
  table = load_csv(StringIO.StringIO(csvdata))
  table.set_type('EmployeeID', float)
  table.set_type('FirstName', unicode)
  table.set_type('MiddleInitial',  unicode)
  table.set_type('LastName',  unicode)
  table.set_type('Address',  unicode)
  return table  

#-----------------------------------------------------------------------------------#
#           Testing
#-----------------------------------------------------------------------------------#
if __name__=="__main__":
    tbl = example_input()
    results = run(tbl,'SSN',0)
    results[0].view()

