#!/usr/bin/python

import wx, pickle



#######################################
###   The map we use for preferences
_config = None

#######################################
###   Accessor functions

def init():
  '''Initializes the preferences'''
  global _config
  _config = wx.Config('Picalo')
  
  
def save():
  '''Saves the configuration to file'''
  _config.Flush()


def get(key, default=None):
  '''Returns the given key'''
  if _config.Exists(key):
    return pickle.loads(str(_config.Read(key)))
  return default
  
  
def put(key, value):
  '''Puts a value in the preferences'''
  _config.Write(key, pickle.dumps(value))
  

def set(key, value):
  '''Puts a value in the preferences (synonym for put)'''
  put(key, value)

  
def remove(key):
  '''Removes the given value'''
  _config.DeleteEntry(key)