#!/usr/bin/python

####################################################################################
#                                                                                  #
# Copyright (c) 2005 Dr. Conan C. Albrecht <conan_albrechtATbyuDOTedu>             #
#                                                                                  #
# This file is part of Picalo.                                                     #
#                                                                                  #
# Picalo is free software; you can redistribute it and/or modify                   #
# it under the terms of the GNU General Public License as published by             #
# the Free Software Foundation; either version 2 of the License, or                # 
# (at your option) any later version.                                              #
#                                                                                  #
# Picalo is distributed in the hope that it will be useful,                        #
# but WITHOUT ANY WARRANTY; without even the implied warranty of                   #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                    #
# GNU General Public License for more details.                                     #
#                                                                                  #
# You should have received a copy of the GNU General Public License                #
# along with Foobar; if not, write to the Free Software                            #
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA        #
#                                                                                  #
####################################################################################
#
# 12 Sep 2005 First version
#
####################################################################################

import wx.py, os, os.path, time, sys
from NotebookComponent import NotebookComponent
import Editor, Utils
from Languages import lang


#################################
###   PyEditor extension

class Output(wx.py.editwindow.EditWindow, NotebookComponent):
  '''Customized version of py's Editor'''
  def __init__(self, parent, mainframe):
    wx.py.editwindow.EditWindow.__init__(self, parent)
    NotebookComponent.__init__(self, parent, mainframe)
    self.SetEndAtLastLine(True)
    self.newtext = False

    # update my styles
    Editor.updateStyles(self)
    self.SetWrapMode(True)
    
    # events
    self.Bind(wx.EVT_IDLE, self.onIdle)
    
    # menu and toolbar for this window    
    self.menuitems = [
    ]
    
    
  def onCopy(self, event=None):
    self.Copy()
  def onSelectAll(self, event=None):
    self.SelectAll()



  def updatePreferences(self):
    '''Signals that the preferences have been updated and this window should update itself'''
    Editor.updateStyles(self)
    
    
  def onIdle(self, event=None):
    '''Watches the output window and scrolls to the bottom when necessary.
       This is in a separate thread because calling these methods at each write
       can make the system unstable (too many times, too fast)'''
    if self.newtext:
      self.newtext = False
      self.GotoLine(self.GetLineCount())
    
    
  def clear(self, event=None):
    self.SetText("")
    
    
  def writeln(self, st):
    '''Method to write a string, plus a newline'''
    self.write(st)
    self.write('\n')
    
    
  def write(self, st):
    '''Method to imitate a stream'''
    self.AppendText(st)
    self.newtext = True
    # when running a script, the UI doesn't update because no idle time, so let's let it
    self.onIdle()
    self.Update()
    
  
  def flush(self):
    '''Method to imitate a stream'''
    pass
    
    
  def close(self):
    '''Method to imitate a stream'''
    pass   
 