#!/usr/bin/python

####################################################################################
#                                                                                  #
# Copyright (c) 2005 Dr. Conan C. Albrecht <conan_albrechtATbyuDOTedu>             #
#                                                                                  #
# This file is part of Picalo.                                                     #
#                                                                                  #
# Picalo is free software; you can redistribute it and/or modify                   #
# it under the terms of the GNU General Public License as published by             #
# the Free Software Foundation; either version 2 of the License, or                # 
# (at your option) any later version.                                              #
#                                                                                  #
# Picalo is distributed in the hope that it will be useful,                        #
# but WITHOUT ANY WARRANTY; without even the implied warranty of                   #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                    #
# GNU General Public License for more details.                                     #
#                                                                                  #
# You should have received a copy of the GNU General Public License                #
# along with Foobar; if not, write to the Free Software                            #
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA        #
#                                                                                  #
####################################################################################
#
#  A simple validator for controls
#
####################################################################################

import wx

class ControlValidator(wx.PyValidator):
    '''A simple validator shamelessly ripped from the wxPython demo, then modified.'''
    def __init__(self, valid_digits=''):
        '''Creates the validator.  Send in the digits that area allowed.'''
        wx.PyValidator.__init__(self)
        self.Bind(wx.EVT_CHAR, self.OnChar)
        self.valid_digits = valid_digits


    def Clone(self):
        return ControlValidator(self.valid_digits)


    def Validate(self, win):
        tc = self.GetWindow()
        val = tc.GetValue()
        for x in val:
            if x not in self.valid_digits:
                return False
        return True


    def OnChar(self, event):
        key = event.GetKeyCode
        if key < wx.WXK_SPACE or key == wx.WXK_DELETE or key > 255:
            event.Skip()
            return

        if chr(key) in self.valid_digits:
            event.Skip()
            return

        if not wx.Validator_IsSilent():
            wx.Bell()

        # Returning without calling even.Skip eats the event before it
        # gets to the text control
        return


    def TransferToWindow(*args, **kwargs):
        """TransferToWindow(self) -> bool"""
        return True
        

    def TransferFromWindow(*args, **kwargs):
        """TransferFromWindow(self) -> bool"""
        return True

