#!/usr/bin/python

from picalo.gui import Utils
from picalo.gui import Languages
import codecs, re

print 'Be sure to run update_language_files.py before running this script.'



# automatically creates the fun "language" files like l33t, elmer fudd, etc.
def create_language(replace_func, langname):
  # load the language file
  lang = Languages.LanguageFile(langname)

  # do the replacements
  for key in lang:
    if key[:5] != 'Ctrl+':  # don't mess with keyboard shortcuts
      value = []
      for word in key.split(' '):
        newword = replace_func(word.lower())
        if word.upper() == word:  # uppercase
          newword = newword.upper()
        elif word[:1].upper() == word[:1]:  # first letter uppercase
          newword = newword[:1].upper() + newword[1:]
        value.append(newword)
      lang[key] = u' '.join(value)

  # save it
  print langname, ':', len(lang), 'phrases created.'
  f = codecs.open(Utils.getResourcePath(langname + '.language'), 'w', 'ISO-8859-1')
  for st in lang.keys():
    print >> f, st
    print >> f, ''
    if lang.has_explicit_key(st):
      print >> f, lang[st]
    else:
      print >> f, ''
    print >> f, ''
    print >> f, ''
    print >> f, ''
    print >> f, ''
  f.close()


##########################################
###   L33T

leet_replacements = [
 ( 'ck', 'x' ),
 ( 's', '5' ),
 ( 'l', '1' ),
 ( 'f', 'ph' ),
 ( 'a', '4' ),
 ( 'e', '3' ),
 ( 'i', '1' ),
 ( 'o', '0' ),
 ( 'z', '2' ),
 ( 'and', 'nd' ),
 ( 'dude', 'd00d' ),
 ( 'from', 'f0rm' ),
 ( 'cool', 'kewl' ),
 ( 'own', 'pwn' ),
 ( 'the', 't3h' ),
 ( 'when', 'wen' ),
 ( 'what', 'whut' ),
 ( 'you', 'u' ),
 ( 'are', 'r' ),
 ( 'picalo', 'picalo (woot!)' ),
 ( 'error', 'error (owns we you)')
]
leet_replacements.sort(lambda a,b: cmp(len(b[0]), len(a[0])))  # longer ones have to go first
def leet(st):
  for ch1, ch2 in leet_replacements:
    st = st.replace(ch1, ch2)
  return st
create_language(leet, 'l33t')


############################################
###   PigLatin

def pig_latin(st):
  # remove any starting or ending characters
  start = 0
  end = len(st)
  while start < len(st) and st[start:start+1].lower() not in 'abcdefghijklmnopqrstuvwxyz':
    start += 1
  while end > 0 and st[end-1: end].lower() not in 'abcdefghijklmnopqrstuvwxyz':
    end -= 1
  if start == len(st) or end == 0:  # we don't have any letters!
    return st
  usest = st[start: end]
  # do the pig latin
  if usest[:1].lower() in 'aeiou': 
    usest = usest + 'way'
  else:
    pos = 0
    capto = 0
    while pos < len(usest) and usest[pos].lower() in 'bcdfghjklmnpqrstvwxyz':
      if usest[pos:pos+2].lower() == 'qu':
        pos += 2
      else:
        if usest[pos].upper() == usest[pos]:
          capto = pos+1
        pos += 1
    usest = usest[pos:] + usest[:pos].lower() + 'ay'
    if capto > 0:
      usest = usest[:capto].upper() + usest[capto:]
  return st[:start] + usest + st[end:]
create_language(pig_latin, 'Pig Latin')


################################################
###   Elmer Fudd
###   Taken from the "Dive Into Python" book

elmer_subs = ((r'[rl]', r'w'),
            (r'qu', r'qw'),
            (r'th\b', r'f'),
            (r'th', r'd'),
            (r'n[.]', r'n, uh-hah-hah-hah.'))

def elmer(st):
  for fromPattern, toPattern in elmer_subs:
    st = re.sub(fromPattern, toPattern, st)
  return st
create_language(elmer, 'Elmer Fudd')
  
  
#############################################
###   Swedish Chef

chef_subs = ((r'a([nu])', r'u\1'),
            (r'A([nu])', r'U\1'),
            (r'a\B', r'e'),
            (r'A\B', r'E'),
            (r'en\b', r'ee'),
            (r'\Bew', r'oo'),
            (r'\Be\b', r'e-a'),
            (r'\be', r'i'),
            (r'\bE', r'I'),
            (r'\Bf', r'ff'),
            (r'\Bir', r'ur'),
            (r'(\w*?)i(\w*?)$', r'\1ee\2'),
            (r'\bow', r'oo'),
            (r'\bo', r'oo'),
            (r'\bO', r'Oo'),
            (r'the', r'zee'),
            (r'The', r'Zee'),
            (r'th\b', r't'),
            (r'\Btion', r'shun'),
            (r'\Bu', r'oo'),
            (r'\BU', r'Oo'),
            (r'v', r'f'),
            (r'V', r'F'),
            (r'w', r'w'),
            (r'W', r'W'),
            (r'([a-z])[.]', r'\1.  Bork Bork Bork!'))  
def swedish_chef(st):            
  for fromPattern, toPattern in chef_subs:
    st = re.sub(fromPattern, toPattern, st)
  return st
create_language(swedish_chef, 'Swedish Chef')
            